/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.duplication;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.PathAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.duplication.Duplication;
import org.sonar.ce.task.projectanalysis.duplication.DuplicationRepository;
import org.sonar.ce.task.projectanalysis.duplication.InnerDuplicate;
import org.sonar.ce.task.projectanalysis.duplication.TextBlock;
import org.sonar.ce.task.projectanalysis.formula.Counter;
import org.sonar.ce.task.projectanalysis.formula.CounterInitializationContext;
import org.sonar.ce.task.projectanalysis.formula.CreateMeasureContext;
import org.sonar.ce.task.projectanalysis.formula.Formula;
import org.sonar.ce.task.projectanalysis.formula.FormulaExecutorComponentVisitor;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;

public class DuplicationMeasures {
    protected final ImmutableList<Formula> formulas;
    protected final TreeRootHolder treeRootHolder;
    protected final MetricRepository metricRepository;
    protected final MeasureRepository measureRepository;
    private final DuplicationRepository duplicationRepository;

    public DuplicationMeasures(TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository, @Nullable DuplicationRepository duplicationRepository) {
        this.treeRootHolder = treeRootHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
        this.duplicationRepository = duplicationRepository;
        this.formulas = ImmutableList.of((Object)new DuplicationFormula());
    }

    public DuplicationMeasures(TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository) {
        this(treeRootHolder, metricRepository, measureRepository, null);
    }

    public void execute() {
        new PathAwareCrawler<FormulaExecutorComponentVisitor.Counters>(FormulaExecutorComponentVisitor.newBuilder(this.metricRepository, this.measureRepository).buildFor((Iterable<Formula>)this.formulas)).visit(this.treeRootHolder.getReportTreeRoot());
    }

    protected DuplicationCounter createCounter() {
        return new DuplicationCounter(this.duplicationRepository);
    }

    private final class DuplicationFormula
    implements Formula<DuplicationCounter> {
        private DuplicationFormula() {
        }

        @Override
        public DuplicationCounter createNewCounter() {
            return DuplicationMeasures.this.createCounter();
        }

        @Override
        public Optional<Measure> createMeasure(DuplicationCounter counter, CreateMeasureContext context) {
            switch (context.getMetric().getKey()) {
                case "duplicated_files": {
                    return Optional.of(Measure.newMeasureBuilder().create(counter.fileCount));
                }
                case "duplicated_lines": {
                    return Optional.of(Measure.newMeasureBuilder().create(counter.dupLineCount));
                }
                case "duplicated_lines_density": {
                    return this.createDuplicatedLinesDensityMeasure(counter, context);
                }
                case "duplicated_blocks": {
                    return Optional.of(Measure.newMeasureBuilder().create(counter.blockCount));
                }
            }
            throw new IllegalArgumentException("Unsupported metric " + context.getMetric());
        }

        private Optional<Measure> createDuplicatedLinesDensityMeasure(DuplicationCounter counter, CreateMeasureContext context) {
            int duplicatedLines = counter.dupLineCount;
            int nbLines = counter.lineCount;
            if (nbLines > 0) {
                double density = Math.min(100.0, 100.0 * (double)duplicatedLines / (double)nbLines);
                return Optional.of(Measure.newMeasureBuilder().create(density, context.getMetric().getDecimalScale()));
            }
            return Optional.empty();
        }

        @Override
        public String[] getOutputMetricKeys() {
            return new String[]{"duplicated_files", "duplicated_lines", "duplicated_lines_density", "duplicated_blocks"};
        }
    }

    protected static class DuplicationCounter
    implements Counter<DuplicationCounter> {
        @CheckForNull
        private final DuplicationRepository duplicationRepository;
        protected int fileCount = 0;
        protected int blockCount = 0;
        protected int dupLineCount = 0;
        protected int lineCount = 0;

        protected DuplicationCounter() {
            this(null);
        }

        private DuplicationCounter(@Nullable DuplicationRepository duplicationRepository) {
            this.duplicationRepository = duplicationRepository;
        }

        @Override
        public void aggregate(DuplicationCounter counter) {
            this.fileCount += counter.fileCount;
            this.blockCount += counter.blockCount;
            this.dupLineCount += counter.dupLineCount;
            this.lineCount += counter.lineCount;
        }

        @Override
        public void initialize(CounterInitializationContext context) {
            Component leaf = context.getLeaf();
            if (leaf.getType() == Component.Type.FILE) {
                this.initializeForFile(leaf);
            } else if (leaf.getType() == Component.Type.PROJECT_VIEW) {
                this.initializeForProjectView(context);
            }
        }

        protected void initializeForFile(Component file) {
            this.lineCount = file.getFileAttributes().getLines();
            Iterable<Duplication> duplications = Objects.requireNonNull(this.duplicationRepository, "DuplicationRepository missing").getDuplications(file);
            if (Iterables.isEmpty(duplications)) {
                return;
            }
            HashSet<Integer> duplicatedLineNumbers = new HashSet<Integer>();
            int blocks = 0;
            for (Duplication duplication : duplications) {
                ++blocks;
                DuplicationCounter.addLines(duplication.getOriginal(), duplicatedLineNumbers);
                for (InnerDuplicate innerDuplicate : FluentIterable.from(duplication.getDuplicates()).filter(InnerDuplicate.class)) {
                    ++blocks;
                    DuplicationCounter.addLines(innerDuplicate.getTextBlock(), duplicatedLineNumbers);
                }
            }
            ++this.fileCount;
            this.blockCount += blocks;
            this.dupLineCount += duplicatedLineNumbers.size();
        }

        private static void addLines(TextBlock textBlock, Set<Integer> duplicatedLineNumbers) {
            for (int i = textBlock.getStart(); i <= textBlock.getEnd(); ++i) {
                duplicatedLineNumbers.add(i);
            }
        }

        private void initializeForProjectView(CounterInitializationContext context) {
            this.fileCount += DuplicationCounter.getMeasure(context, "duplicated_files");
            this.blockCount += DuplicationCounter.getMeasure(context, "duplicated_blocks");
            this.dupLineCount += DuplicationCounter.getMeasure(context, "duplicated_lines");
            this.lineCount += DuplicationCounter.getMeasure(context, "lines");
        }

        private static int getMeasure(CounterInitializationContext context, String metricKey) {
            Optional<Measure> files = context.getMeasure(metricKey);
            return files.map(Measure::getIntValue).orElse(0);
        }
    }
}

