/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.System2;
import org.sonar.ce.task.projectanalysis.issue.NewAdHocRule;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.rule.RuleDao;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.rule.RuleDto;
import org.sonar.db.rule.RuleMetadataDto;
import org.sonar.server.rule.index.RuleIndexer;

public class AdHocRuleCreator {
    private static final int MAX_LENGTH_AD_HOC_NAME = 200;
    private static final int MAX_LENGTH_AD_HOC_DESC = 0xFFFFFF;
    private final DbClient dbClient;
    private final System2 system2;
    private final RuleIndexer ruleIndexer;

    public AdHocRuleCreator(DbClient dbClient, System2 system2, RuleIndexer ruleIndexer) {
        this.dbClient = dbClient;
        this.system2 = system2;
        this.ruleIndexer = ruleIndexer;
    }

    public RuleDto persistAndIndex(DbSession dbSession, NewAdHocRule adHoc, OrganizationDto organizationDto) {
        RuleMetadataDto metadata;
        RuleDao dao = this.dbClient.ruleDao();
        Optional existingRuleDtoOpt = dao.selectByKey(dbSession, organizationDto, adHoc.getKey());
        long now = this.system2.now();
        if (!existingRuleDtoOpt.isPresent()) {
            RuleDefinitionDto dto = new RuleDefinitionDto().setRuleKey(adHoc.getKey()).setIsExternal(true).setIsAdHoc(true).setName(adHoc.getEngineId() + ":" + adHoc.getRuleId()).setScope(RuleDto.Scope.ALL).setStatus(RuleStatus.READY).setCreatedAt(now).setUpdatedAt(now);
            dao.insert(dbSession, dto);
            metadata = new RuleMetadataDto().setRuleId(dto.getId().intValue()).setOrganizationUuid(organizationDto.getUuid());
        } else {
            RuleDto ruleDto = (RuleDto)existingRuleDtoOpt.get();
            Preconditions.checkState((ruleDto.isExternal() && ruleDto.isAdHoc() ? 1 : 0) != 0);
            metadata = ruleDto.getMetadata();
        }
        if (adHoc.hasDetails()) {
            boolean changed = false;
            if (!Objects.equals(metadata.getAdHocName(), adHoc.getName())) {
                metadata.setAdHocName(StringUtils.substring((String)adHoc.getName(), (int)0, (int)200));
                changed = true;
            }
            if (!Objects.equals(metadata.getAdHocDescription(), adHoc.getDescription())) {
                metadata.setAdHocDescription(StringUtils.substring((String)adHoc.getDescription(), (int)0, (int)0xFFFFFF));
                changed = true;
            }
            if (!Objects.equals(metadata.getAdHocSeverity(), adHoc.getSeverity())) {
                metadata.setAdHocSeverity(adHoc.getSeverity());
                changed = true;
            }
            RuleType ruleType = Objects.requireNonNull(adHoc.getRuleType(), "Rule type should not be null");
            if (!Objects.equals(metadata.getAdHocType(), ruleType.getDbConstant())) {
                metadata.setAdHocType(ruleType);
                changed = true;
            }
            if (changed) {
                metadata.setUpdatedAt(now);
                metadata.setCreatedAt(now);
                dao.insertOrUpdate(dbSession, metadata);
            }
        }
        RuleDto ruleDto = dao.selectOrFailByKey(dbSession, organizationDto, adHoc.getKey());
        this.ruleIndexer.commitAndIndex(dbSession, ruleDto.getId().intValue());
        return ruleDto;
    }
}

