/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import java.util.Comparator;
import java.util.Date;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.DateUtils;
import org.sonar.ce.task.projectanalysis.analysis.Analysis;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.analysis.ScannerPlugin;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.filemove.AddedFileRepository;
import org.sonar.ce.task.projectanalysis.issue.IssueLocations;
import org.sonar.ce.task.projectanalysis.issue.IssueVisitor;
import org.sonar.ce.task.projectanalysis.issue.Rule;
import org.sonar.ce.task.projectanalysis.issue.RuleRepository;
import org.sonar.ce.task.projectanalysis.qualityprofile.ActiveRule;
import org.sonar.ce.task.projectanalysis.qualityprofile.ActiveRulesHolder;
import org.sonar.ce.task.projectanalysis.qualityprofile.QProfileStatusRepository;
import org.sonar.ce.task.projectanalysis.scm.Changeset;
import org.sonar.ce.task.projectanalysis.scm.ScmInfo;
import org.sonar.ce.task.projectanalysis.scm.ScmInfoRepository;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.server.issue.IssueFieldsSetter;

public class IssueCreationDateCalculator
extends IssueVisitor {
    private final ScmInfoRepository scmInfoRepository;
    private final IssueFieldsSetter issueUpdater;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final IssueChangeContext changeContext;
    private final ActiveRulesHolder activeRulesHolder;
    private final RuleRepository ruleRepository;
    private final AddedFileRepository addedFileRepository;
    private QProfileStatusRepository qProfileStatusRepository;

    public IssueCreationDateCalculator(AnalysisMetadataHolder analysisMetadataHolder, ScmInfoRepository scmInfoRepository, IssueFieldsSetter issueUpdater, ActiveRulesHolder activeRulesHolder, RuleRepository ruleRepository, AddedFileRepository addedFileRepository, QProfileStatusRepository qProfileStatusRepository) {
        this.scmInfoRepository = scmInfoRepository;
        this.issueUpdater = issueUpdater;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.ruleRepository = ruleRepository;
        this.changeContext = IssueChangeContext.createScan((Date)new Date(analysisMetadataHolder.getAnalysisDate()));
        this.activeRulesHolder = activeRulesHolder;
        this.addedFileRepository = addedFileRepository;
        this.qProfileStatusRepository = qProfileStatusRepository;
    }

    @Override
    public void onIssue(Component component, DefaultIssue issue) {
        boolean firstAnalysis;
        if (!issue.isNew()) {
            return;
        }
        Optional<Long> lastAnalysisOptional = this.lastAnalysis();
        boolean bl = firstAnalysis = !lastAnalysisOptional.isPresent();
        if (firstAnalysis || this.isNewFile(component)) {
            this.backdateIssue(component, issue);
            return;
        }
        Rule rule = this.ruleRepository.findByKey(issue.getRuleKey()).orElseThrow(IssueCreationDateCalculator.illegalStateException("The rule with key '%s' raised an issue, but no rule with that key was found", issue.getRuleKey()));
        if (rule.isExternal()) {
            this.backdateIssue(component, issue);
        } else {
            ActiveRule activeRule = this.activeRulesHolder.get(issue.getRuleKey()).get();
            if (IssueCreationDateCalculator.activeRuleIsNewOrChanged(activeRule, lastAnalysisOptional.get()) || this.ruleImplementationChanged(activeRule.getRuleKey(), activeRule.getPluginKey(), lastAnalysisOptional.get()) || this.qualityProfileChanged(activeRule.getQProfileKey())) {
                this.backdateIssue(component, issue);
            }
        }
    }

    private boolean qualityProfileChanged(String qpKey) {
        return this.qProfileStatusRepository.get(qpKey).filter(s -> !s.equals((Object)QProfileStatusRepository.Status.UNCHANGED)).isPresent();
    }

    private boolean isNewFile(Component component) {
        return component.getType() == Component.Type.FILE && this.addedFileRepository.isAdded(component);
    }

    private void backdateIssue(Component component, DefaultIssue issue) {
        this.getDateOfLatestChange(component, issue).ifPresent(changeDate -> this.updateDate(issue, (Date)changeDate));
    }

    private boolean ruleImplementationChanged(RuleKey ruleKey, @Nullable String pluginKey, long lastAnalysisDate) {
        if (pluginKey == null) {
            return false;
        }
        ScannerPlugin scannerPlugin = Optional.ofNullable(this.analysisMetadataHolder.getScannerPluginsByKey().get(pluginKey)).orElseThrow(IssueCreationDateCalculator.illegalStateException("The rule %s is declared to come from plugin %s, but this plugin was not used by scanner.", ruleKey, pluginKey));
        return IssueCreationDateCalculator.pluginIsNew(scannerPlugin, lastAnalysisDate) || this.basePluginIsNew(scannerPlugin, lastAnalysisDate);
    }

    private boolean basePluginIsNew(ScannerPlugin scannerPlugin, long lastAnalysisDate) {
        String basePluginKey = scannerPlugin.getBasePluginKey();
        if (basePluginKey == null) {
            return false;
        }
        ScannerPlugin basePlugin = this.analysisMetadataHolder.getScannerPluginsByKey().get(basePluginKey);
        return lastAnalysisDate < basePlugin.getUpdatedAt();
    }

    private static boolean pluginIsNew(ScannerPlugin scannerPlugin, long lastAnalysisDate) {
        return lastAnalysisDate < scannerPlugin.getUpdatedAt();
    }

    private static boolean activeRuleIsNewOrChanged(ActiveRule activeRule, Long lastAnalysisDate) {
        return lastAnalysisDate < activeRule.getUpdatedAt();
    }

    private Optional<Date> getDateOfLatestChange(Component component, DefaultIssue issue) {
        return this.getScmInfo(component).flatMap(scmInfo -> IssueCreationDateCalculator.getLatestChangeset(component, scmInfo, issue)).map(IssueCreationDateCalculator::getChangeDate);
    }

    private Optional<Long> lastAnalysis() {
        return Optional.ofNullable(this.analysisMetadataHolder.getBaseAnalysis()).map(Analysis::getCreatedAt);
    }

    private Optional<ScmInfo> getScmInfo(Component component) {
        return this.scmInfoRepository.getScmInfo(component);
    }

    private static Optional<Changeset> getLatestChangeset(Component component, ScmInfo scmInfo, DefaultIssue issue) {
        Optional<Changeset> mostRecentChangeset = IssueLocations.allLinesFor(issue, component.getUuid()).filter(scmInfo::hasChangesetForLine).mapToObj(scmInfo::getChangesetForLine).max(Comparator.comparingLong(Changeset::getDate));
        if (mostRecentChangeset.isPresent()) {
            return mostRecentChangeset;
        }
        return Optional.of(scmInfo.getLatestChangeset());
    }

    private static Date getChangeDate(Changeset changesetForLine) {
        return DateUtils.longToDate((Long)changesetForLine.getDate());
    }

    private void updateDate(DefaultIssue issue, Date scmDate) {
        this.issueUpdater.setCreationDate(issue, scmDate, this.changeContext);
    }

    private static Supplier<? extends IllegalStateException> illegalStateException(String str, Object ... args) {
        return () -> new IllegalStateException(String.format(str, args));
    }
}

