/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.filemove.MovedFilesRepository;
import org.sonar.ce.task.projectanalysis.issue.IssueVisitor;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.server.issue.IssueFieldsSetter;

public class MovedIssueVisitor
extends IssueVisitor {
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final MovedFilesRepository movedFilesRepository;
    private final IssueFieldsSetter issueUpdater;

    public MovedIssueVisitor(AnalysisMetadataHolder analysisMetadataHolder, MovedFilesRepository movedFilesRepository, IssueFieldsSetter issueUpdater) {
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.movedFilesRepository = movedFilesRepository;
        this.issueUpdater = issueUpdater;
    }

    @Override
    public void onIssue(Component component, DefaultIssue issue) {
        if (component.getType() != Component.Type.FILE || component.getUuid().equals(issue.componentUuid())) {
            return;
        }
        Optional<MovedFilesRepository.OriginalFile> originalFileOptional = this.movedFilesRepository.getOriginalFile(component);
        Preconditions.checkState((boolean)originalFileOptional.isPresent(), (String)"Issue %s for component %s has a different component key but no original file exist in MovedFilesRepository", (Object[])new Object[]{issue, component});
        MovedFilesRepository.OriginalFile originalFile = (MovedFilesRepository.OriginalFile)originalFileOptional.get();
        Preconditions.checkState((boolean)originalFile.getUuid().equals(issue.componentUuid()), (String)"Issue %s doesn't belong to file %s registered as original file of current file %s", (Object[])new Object[]{issue, originalFile.getUuid(), component});
        this.issueUpdater.setIssueMoved(issue, component.getUuid(), IssueChangeContext.createUser((Date)new Date(this.analysisMetadataHolder.getAnalysisDate()), null));
        issue.setComponentKey(component.getKey());
        issue.setModuleUuid(null);
        issue.setModuleUuidPath(null);
    }
}

