/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.Duration;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.task.projectanalysis.batch.BatchReportReader;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.issue.NewAdHocRule;
import org.sonar.ce.task.projectanalysis.issue.Rule;
import org.sonar.ce.task.projectanalysis.issue.RuleRepository;
import org.sonar.ce.task.projectanalysis.issue.commonrule.CommonRuleEngine;
import org.sonar.ce.task.projectanalysis.issue.filter.IssueFilter;
import org.sonar.ce.task.projectanalysis.qualityprofile.ActiveRulesHolder;
import org.sonar.ce.task.projectanalysis.source.SourceLinesHashRepository;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.tracking.Input;
import org.sonar.core.issue.tracking.LazyInput;
import org.sonar.core.issue.tracking.LineHashSequence;
import org.sonar.core.util.CloseableIterator;
import org.sonar.db.protobuf.DbCommons;
import org.sonar.db.protobuf.DbIssues;
import org.sonar.scanner.protocol.Constants;
import org.sonar.scanner.protocol.output.ScannerReport;

public class TrackerRawInputFactory {
    private static final long DEFAULT_EXTERNAL_ISSUE_EFFORT = 0L;
    private final TreeRootHolder treeRootHolder;
    private final BatchReportReader reportReader;
    private final CommonRuleEngine commonRuleEngine;
    private final IssueFilter issueFilter;
    private final SourceLinesHashRepository sourceLinesHash;
    private final RuleRepository ruleRepository;
    private final ActiveRulesHolder activeRulesHolder;

    public TrackerRawInputFactory(TreeRootHolder treeRootHolder, BatchReportReader reportReader, SourceLinesHashRepository sourceLinesHash, CommonRuleEngine commonRuleEngine, IssueFilter issueFilter, RuleRepository ruleRepository, ActiveRulesHolder activeRulesHolder) {
        this.treeRootHolder = treeRootHolder;
        this.reportReader = reportReader;
        this.sourceLinesHash = sourceLinesHash;
        this.commonRuleEngine = commonRuleEngine;
        this.issueFilter = issueFilter;
        this.ruleRepository = ruleRepository;
        this.activeRulesHolder = activeRulesHolder;
    }

    public Input<DefaultIssue> create(Component component) {
        return new RawLazyInput(component);
    }

    private class RawLazyInput
    extends LazyInput<DefaultIssue> {
        private final Component component;

        private RawLazyInput(Component component) {
            this.component = component;
        }

        protected LineHashSequence loadLineHashSequence() {
            if (this.component.getType() == Component.Type.FILE) {
                return new LineHashSequence(TrackerRawInputFactory.this.sourceLinesHash.getLineHashesMatchingDBVersion(this.component));
            }
            return new LineHashSequence(Collections.emptyList());
        }

        protected List<DefaultIssue> loadIssues() {
            ArrayList<DefaultIssue> result = new ArrayList<DefaultIssue>();
            for (DefaultIssue defaultIssue : TrackerRawInputFactory.this.commonRuleEngine.process(this.component)) {
                if (!TrackerRawInputFactory.this.issueFilter.accept(defaultIssue, this.component)) continue;
                result.add(this.init(defaultIssue));
            }
            if (this.component.getReportAttributes().getRef() == null) {
                return result;
            }
            Throwable throwable = null;
            try (CloseableIterator<ScannerReport.Issue> reportIssues = TrackerRawInputFactory.this.reportReader.readComponentIssues(this.component.getReportAttributes().getRef());){
                while (reportIssues.hasNext()) {
                    ScannerReport.Issue reportIssue = (ScannerReport.Issue)reportIssues.next();
                    if (this.isOnInactiveRule(reportIssue)) continue;
                    if (!this.isIssueOnUnsupportedCommonRule(reportIssue)) {
                        Loggers.get(((Object)((Object)this)).getClass()).debug("Ignored issue from analysis report on rule {}:{}", (Object)reportIssue.getRuleRepository(), (Object)reportIssue.getRuleKey());
                        continue;
                    }
                    DefaultIssue issue = this.toIssue(this.getLineHashSequence(), reportIssue);
                    if (!TrackerRawInputFactory.this.issueFilter.accept(issue, this.component)) continue;
                    result.add(issue);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            HashMap<RuleKey, ScannerReport.AdHocRule> adHocRuleMap = new HashMap<RuleKey, ScannerReport.AdHocRule>();
            try (CloseableIterator<ScannerReport.AdHocRule> closeableIterator = TrackerRawInputFactory.this.reportReader.readAdHocRules();){
                while (closeableIterator.hasNext()) {
                    ScannerReport.AdHocRule adHocRule = (ScannerReport.AdHocRule)closeableIterator.next();
                    adHocRuleMap.put(RuleKey.of((String)("external_" + adHocRule.getEngineId()), (String)adHocRule.getRuleId()), adHocRule);
                }
            }
            var4_8 = null;
            try (CloseableIterator<ScannerReport.ExternalIssue> closeableIterator = TrackerRawInputFactory.this.reportReader.readComponentExternalIssues(this.component.getReportAttributes().getRef());){
                while (closeableIterator.hasNext()) {
                    ScannerReport.ExternalIssue reportExternalIssue = (ScannerReport.ExternalIssue)closeableIterator.next();
                    result.add(this.toExternalIssue(this.getLineHashSequence(), reportExternalIssue, adHocRuleMap));
                }
            }
            catch (Throwable throwable4) {
                var4_8 = throwable4;
                throw throwable4;
            }
            return result;
        }

        private boolean isOnInactiveRule(ScannerReport.Issue reportIssue) {
            RuleKey ruleKey = RuleKey.of((String)reportIssue.getRuleRepository(), (String)reportIssue.getRuleKey());
            return !TrackerRawInputFactory.this.activeRulesHolder.get(ruleKey).isPresent();
        }

        private boolean isIssueOnUnsupportedCommonRule(ScannerReport.Issue issue) {
            return !issue.getRuleRepository().startsWith("common-");
        }

        private DefaultIssue toIssue(LineHashSequence lineHashSeq, ScannerReport.Issue reportIssue) {
            DefaultIssue issue = new DefaultIssue();
            this.init(issue);
            RuleKey ruleKey = RuleKey.of((String)reportIssue.getRuleRepository(), (String)reportIssue.getRuleKey());
            issue.setRuleKey(ruleKey);
            if (reportIssue.hasTextRange()) {
                int startLine = reportIssue.getTextRange().getStartLine();
                issue.setLine(Integer.valueOf(startLine));
                issue.setChecksum(lineHashSeq.getHashForLine(startLine));
            } else {
                issue.setChecksum("");
            }
            if (StringUtils.isNotEmpty((String)reportIssue.getMsg())) {
                issue.setMessage(reportIssue.getMsg());
            } else {
                Rule rule = TrackerRawInputFactory.this.ruleRepository.getByKey(ruleKey);
                issue.setMessage(rule.getName());
            }
            if (reportIssue.getSeverity() != Constants.Severity.UNSET_SEVERITY) {
                issue.setSeverity(reportIssue.getSeverity().name());
            }
            if (reportIssue.getGap() != 0.0) {
                issue.setGap(Double.valueOf(reportIssue.getGap()));
            }
            DbIssues.Locations.Builder dbLocationsBuilder = DbIssues.Locations.newBuilder();
            if (reportIssue.hasTextRange()) {
                dbLocationsBuilder.setTextRange(this.convertTextRange(reportIssue.getTextRange()));
            }
            for (ScannerReport.Flow flow : reportIssue.getFlowList()) {
                if (flow.getLocationCount() <= 0) continue;
                DbIssues.Flow.Builder dbFlowBuilder = DbIssues.Flow.newBuilder();
                for (ScannerReport.IssueLocation location : flow.getLocationList()) {
                    this.convertLocation(location).ifPresent(arg_0 -> ((DbIssues.Flow.Builder)dbFlowBuilder).addLocation(arg_0));
                }
                dbLocationsBuilder.addFlow(dbFlowBuilder);
            }
            issue.setIsFromExternalRuleEngine(false);
            issue.setLocations((Object)dbLocationsBuilder.build());
            return issue;
        }

        private DefaultIssue toExternalIssue(LineHashSequence lineHashSeq, ScannerReport.ExternalIssue reportExternalIssue, Map<RuleKey, ScannerReport.AdHocRule> adHocRuleMap) {
            DefaultIssue issue = new DefaultIssue();
            this.init(issue);
            RuleKey ruleKey = RuleKey.of((String)("external_" + reportExternalIssue.getEngineId()), (String)reportExternalIssue.getRuleId());
            issue.setRuleKey(ruleKey);
            if (reportExternalIssue.hasTextRange()) {
                int startLine = reportExternalIssue.getTextRange().getStartLine();
                issue.setLine(Integer.valueOf(startLine));
                issue.setChecksum(lineHashSeq.getHashForLine(startLine));
            } else {
                issue.setChecksum("");
            }
            if (StringUtils.isNotEmpty((String)reportExternalIssue.getMsg())) {
                issue.setMessage(reportExternalIssue.getMsg());
            }
            if (reportExternalIssue.getSeverity() != Constants.Severity.UNSET_SEVERITY) {
                issue.setSeverity(reportExternalIssue.getSeverity().name());
            }
            issue.setEffort(Duration.create((long)(reportExternalIssue.getEffort() != 0L ? reportExternalIssue.getEffort() : 0L)));
            DbIssues.Locations.Builder dbLocationsBuilder = DbIssues.Locations.newBuilder();
            if (reportExternalIssue.hasTextRange()) {
                dbLocationsBuilder.setTextRange(this.convertTextRange(reportExternalIssue.getTextRange()));
            }
            for (ScannerReport.Flow flow : reportExternalIssue.getFlowList()) {
                if (flow.getLocationCount() <= 0) continue;
                DbIssues.Flow.Builder dbFlowBuilder = DbIssues.Flow.newBuilder();
                for (ScannerReport.IssueLocation location : flow.getLocationList()) {
                    this.convertLocation(location).ifPresent(arg_0 -> ((DbIssues.Flow.Builder)dbFlowBuilder).addLocation(arg_0));
                }
                dbLocationsBuilder.addFlow(dbFlowBuilder);
            }
            issue.setIsFromExternalRuleEngine(true);
            issue.setLocations((Object)dbLocationsBuilder.build());
            issue.setType(this.toRuleType(reportExternalIssue.getType()));
            TrackerRawInputFactory.this.ruleRepository.addOrUpdateAddHocRuleIfNeeded(ruleKey, () -> this.toAdHocRule(reportExternalIssue, (ScannerReport.AdHocRule)adHocRuleMap.get(issue.ruleKey())));
            return issue;
        }

        private NewAdHocRule toAdHocRule(ScannerReport.ExternalIssue reportIssue, @Nullable ScannerReport.AdHocRule adHocRule) {
            if (adHocRule != null) {
                return new NewAdHocRule(adHocRule);
            }
            return new NewAdHocRule(reportIssue);
        }

        private RuleType toRuleType(ScannerReport.IssueType type) {
            switch (type) {
                case BUG: {
                    return RuleType.BUG;
                }
                case CODE_SMELL: {
                    return RuleType.CODE_SMELL;
                }
                case VULNERABILITY: {
                    return RuleType.VULNERABILITY;
                }
                case SECURITY_HOTSPOT: {
                    return RuleType.SECURITY_HOTSPOT;
                }
            }
            throw new IllegalStateException("Invalid issue type: " + type);
        }

        private DefaultIssue init(DefaultIssue issue) {
            issue.setResolution(null);
            issue.setStatus("OPEN");
            issue.setComponentUuid(this.component.getUuid());
            issue.setComponentKey(this.component.getKey());
            issue.setProjectUuid(TrackerRawInputFactory.this.treeRootHolder.getRoot().getUuid());
            issue.setProjectKey(TrackerRawInputFactory.this.treeRootHolder.getRoot().getKey());
            return issue;
        }

        private Optional<DbIssues.Location> convertLocation(ScannerReport.IssueLocation source) {
            DbIssues.Location.Builder target = DbIssues.Location.newBuilder();
            if (source.getComponentRef() != 0 && source.getComponentRef() != this.component.getReportAttributes().getRef().intValue()) {
                Optional<Component> optionalComponent = TrackerRawInputFactory.this.treeRootHolder.getOptionalComponentByRef(source.getComponentRef());
                if (!optionalComponent.isPresent()) {
                    return Optional.empty();
                }
                target.setComponentId(optionalComponent.get().getUuid());
            }
            if (StringUtils.isNotEmpty((String)source.getMsg())) {
                target.setMsg(source.getMsg());
            }
            if (source.hasTextRange()) {
                ScannerReport.TextRange sourceRange = source.getTextRange();
                DbCommons.TextRange.Builder targetRange = this.convertTextRange(sourceRange);
                target.setTextRange(targetRange);
            }
            return Optional.of(target.build());
        }

        private DbCommons.TextRange.Builder convertTextRange(ScannerReport.TextRange sourceRange) {
            DbCommons.TextRange.Builder targetRange = DbCommons.TextRange.newBuilder();
            targetRange.setStartLine(sourceRange.getStartLine());
            targetRange.setStartOffset(sourceRange.getStartOffset());
            targetRange.setEndLine(sourceRange.getEndLine());
            targetRange.setEndOffset(sourceRange.getEndOffset());
            return targetRange;
        }
    }
}

