/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue.commonrule;

import java.util.Optional;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.issue.commonrule.CommonRule;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.projectanalysis.qualityprofile.ActiveRule;
import org.sonar.ce.task.projectanalysis.qualityprofile.ActiveRulesHolder;

public class TestErrorRule
extends CommonRule {
    private final MeasureRepository measureRepository;
    private final Metric testErrorMetric;
    private final Metric testFailureMetric;

    public TestErrorRule(ActiveRulesHolder activeRulesHolder, MeasureRepository measureRepository, MetricRepository metricRepository) {
        super(activeRulesHolder, "FailedUnitTests");
        this.measureRepository = measureRepository;
        this.testErrorMetric = metricRepository.getByKey("test_errors");
        this.testFailureMetric = metricRepository.getByKey("test_failures");
    }

    @Override
    protected CommonRule.CommonRuleIssue doProcessFile(Component file, ActiveRule activeRule) {
        int failures;
        Optional<Measure> errorsMeasure = this.measureRepository.getRawMeasure(file, this.testErrorMetric);
        Optional<Measure> failuresMeasure = this.measureRepository.getRawMeasure(file, this.testFailureMetric);
        int errors = errorsMeasure.map(Measure::getIntValue).orElse(0);
        int total = errors + (failures = failuresMeasure.map(Measure::getIntValue).orElse(0).intValue());
        if (total > 0) {
            String message = String.format("Fix failing unit tests on file \"%s\".", file.getName());
            return new CommonRule.CommonRuleIssue(total, message);
        }
        return null;
    }
}

