/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue.filter;

import javax.annotation.Nullable;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.core.issue.DefaultIssue;

public class IssuePattern {
    private WildcardPattern componentPattern;
    private WildcardPattern rulePattern;

    public IssuePattern(String componentPattern, String rulePattern) {
        this.componentPattern = WildcardPattern.create((String)componentPattern);
        this.rulePattern = WildcardPattern.create((String)rulePattern);
    }

    public WildcardPattern getComponentPattern() {
        return this.componentPattern;
    }

    public WildcardPattern getRulePattern() {
        return this.rulePattern;
    }

    boolean match(DefaultIssue issue, Component file) {
        return this.matchComponent(file.getName()) && this.matchRule(issue.ruleKey());
    }

    boolean matchRule(RuleKey rule) {
        return this.rulePattern.match(rule.toString());
    }

    boolean matchComponent(@Nullable String path) {
        return path != null && this.componentPattern.match(path);
    }

    public String toString() {
        return "IssuePattern{componentPattern=" + this.componentPattern + ", rulePattern=" + this.rulePattern + '}';
    }
}

