/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.measure;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.scanner.protocol.output.ScannerReport;

public class BatchMeasureToMeasure {
    public Optional<Measure> toMeasure(@Nullable ScannerReport.Measure batchMeasure, Metric metric) {
        Objects.requireNonNull(metric);
        if (batchMeasure == null) {
            return Optional.empty();
        }
        Measure.NewMeasureBuilder builder = Measure.newMeasureBuilder();
        switch (metric.getType().getValueType()) {
            case INT: {
                return BatchMeasureToMeasure.toIntegerMeasure(builder, batchMeasure);
            }
            case LONG: {
                return BatchMeasureToMeasure.toLongMeasure(builder, batchMeasure);
            }
            case DOUBLE: {
                return BatchMeasureToMeasure.toDoubleMeasure(builder, batchMeasure);
            }
            case BOOLEAN: {
                return BatchMeasureToMeasure.toBooleanMeasure(builder, batchMeasure);
            }
            case STRING: {
                return BatchMeasureToMeasure.toStringMeasure(builder, batchMeasure);
            }
            case LEVEL: {
                return BatchMeasureToMeasure.toLevelMeasure(builder, batchMeasure);
            }
            case NO_VALUE: {
                return BatchMeasureToMeasure.toNoValueMeasure(builder, batchMeasure);
            }
        }
        throw new IllegalArgumentException("Unsupported Measure.ValueType " + (Object)((Object)metric.getType().getValueType()));
    }

    private static Optional<Measure> toIntegerMeasure(Measure.NewMeasureBuilder builder, ScannerReport.Measure batchMeasure) {
        if (batchMeasure.getValueCase() == ScannerReport.Measure.ValueCase.VALUE_NOT_SET) {
            return BatchMeasureToMeasure.toNoValueMeasure(builder, batchMeasure);
        }
        return Optional.of(builder.create(batchMeasure.getIntValue().getValue(), StringUtils.trimToNull((String)batchMeasure.getIntValue().getData())));
    }

    private static Optional<Measure> toLongMeasure(Measure.NewMeasureBuilder builder, ScannerReport.Measure batchMeasure) {
        if (batchMeasure.getValueCase() == ScannerReport.Measure.ValueCase.VALUE_NOT_SET) {
            return BatchMeasureToMeasure.toNoValueMeasure(builder, batchMeasure);
        }
        return Optional.of(builder.create(batchMeasure.getLongValue().getValue(), StringUtils.trimToNull((String)batchMeasure.getLongValue().getData())));
    }

    private static Optional<Measure> toDoubleMeasure(Measure.NewMeasureBuilder builder, ScannerReport.Measure batchMeasure) {
        if (batchMeasure.getValueCase() == ScannerReport.Measure.ValueCase.VALUE_NOT_SET) {
            return BatchMeasureToMeasure.toNoValueMeasure(builder, batchMeasure);
        }
        return Optional.of(builder.create(batchMeasure.getDoubleValue().getValue(), 5, StringUtils.trimToNull((String)batchMeasure.getDoubleValue().getData())));
    }

    private static Optional<Measure> toBooleanMeasure(Measure.NewMeasureBuilder builder, ScannerReport.Measure batchMeasure) {
        if (batchMeasure.getValueCase() == ScannerReport.Measure.ValueCase.VALUE_NOT_SET) {
            return BatchMeasureToMeasure.toNoValueMeasure(builder, batchMeasure);
        }
        return Optional.of(builder.create(batchMeasure.getBooleanValue().getValue(), StringUtils.trimToNull((String)batchMeasure.getBooleanValue().getData())));
    }

    private static Optional<Measure> toStringMeasure(Measure.NewMeasureBuilder builder, ScannerReport.Measure batchMeasure) {
        if (batchMeasure.getValueCase() == ScannerReport.Measure.ValueCase.VALUE_NOT_SET) {
            return BatchMeasureToMeasure.toNoValueMeasure(builder, batchMeasure);
        }
        return Optional.of(builder.create(batchMeasure.getStringValue().getValue()));
    }

    private static Optional<Measure> toLevelMeasure(Measure.NewMeasureBuilder builder, ScannerReport.Measure batchMeasure) {
        if (batchMeasure.getValueCase() == ScannerReport.Measure.ValueCase.VALUE_NOT_SET) {
            return BatchMeasureToMeasure.toNoValueMeasure(builder, batchMeasure);
        }
        Optional<Measure.Level> level = Measure.Level.toLevel(batchMeasure.getStringValue().getValue());
        if (!level.isPresent()) {
            return BatchMeasureToMeasure.toNoValueMeasure(builder, batchMeasure);
        }
        return Optional.of(builder.create(level.get()));
    }

    private static Optional<Measure> toNoValueMeasure(Measure.NewMeasureBuilder builder, ScannerReport.Measure batchMeasure) {
        return Optional.of(builder.createNoValue());
    }
}

