/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.measure;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.QualityGateStatus;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.db.measure.MeasureDto;

public class MeasureDtoToMeasure {
    public Optional<Measure> toMeasure(@Nullable MeasureDto measureDto, Metric metric) {
        Objects.requireNonNull(metric);
        if (measureDto == null) {
            return Optional.empty();
        }
        Double value = measureDto.getValue();
        String data = measureDto.getData();
        switch (metric.getType().getValueType()) {
            case INT: {
                return MeasureDtoToMeasure.toIntegerMeasure(measureDto, value, data);
            }
            case LONG: {
                return MeasureDtoToMeasure.toLongMeasure(measureDto, value, data);
            }
            case DOUBLE: {
                return MeasureDtoToMeasure.toDoubleMeasure(measureDto, value, data);
            }
            case BOOLEAN: {
                return MeasureDtoToMeasure.toBooleanMeasure(measureDto, value, data);
            }
            case STRING: {
                return MeasureDtoToMeasure.toStringMeasure(measureDto, data);
            }
            case LEVEL: {
                return MeasureDtoToMeasure.toLevelMeasure(measureDto, data);
            }
            case NO_VALUE: {
                return MeasureDtoToMeasure.toNoValueMeasure(measureDto);
            }
        }
        throw new IllegalArgumentException("Unsupported Measure.ValueType " + (Object)((Object)metric.getType().getValueType()));
    }

    private static Optional<Measure> toIntegerMeasure(MeasureDto measureDto, @Nullable Double value, String data) {
        if (value == null) {
            return MeasureDtoToMeasure.toNoValueMeasure(measureDto);
        }
        return Optional.of(MeasureDtoToMeasure.setCommonProperties(Measure.newMeasureBuilder(), measureDto).create(value.intValue(), data));
    }

    private static Optional<Measure> toLongMeasure(MeasureDto measureDto, @Nullable Double value, String data) {
        if (value == null) {
            return MeasureDtoToMeasure.toNoValueMeasure(measureDto);
        }
        return Optional.of(MeasureDtoToMeasure.setCommonProperties(Measure.newMeasureBuilder(), measureDto).create(value.longValue(), data));
    }

    private static Optional<Measure> toDoubleMeasure(MeasureDto measureDto, @Nullable Double value, String data) {
        if (value == null) {
            return MeasureDtoToMeasure.toNoValueMeasure(measureDto);
        }
        return Optional.of(MeasureDtoToMeasure.setCommonProperties(Measure.newMeasureBuilder(), measureDto).create(value, 5, data));
    }

    private static Optional<Measure> toBooleanMeasure(MeasureDto measureDto, @Nullable Double value, String data) {
        if (value == null) {
            return MeasureDtoToMeasure.toNoValueMeasure(measureDto);
        }
        return Optional.of(MeasureDtoToMeasure.setCommonProperties(Measure.newMeasureBuilder(), measureDto).create(value == 1.0, data));
    }

    private static Optional<Measure> toStringMeasure(MeasureDto measureDto, @Nullable String data) {
        if (data == null) {
            return MeasureDtoToMeasure.toNoValueMeasure(measureDto);
        }
        return Optional.of(MeasureDtoToMeasure.setCommonProperties(Measure.newMeasureBuilder(), measureDto).create(data));
    }

    private static Optional<Measure> toLevelMeasure(MeasureDto measureDto, @Nullable String data) {
        if (data == null) {
            return MeasureDtoToMeasure.toNoValueMeasure(measureDto);
        }
        Optional<Measure.Level> level = Measure.Level.toLevel(data);
        if (!level.isPresent()) {
            return MeasureDtoToMeasure.toNoValueMeasure(measureDto);
        }
        return Optional.of(MeasureDtoToMeasure.setCommonProperties(Measure.newMeasureBuilder(), measureDto).create(level.get()));
    }

    private static Optional<Measure> toNoValueMeasure(MeasureDto measureDto) {
        return Optional.of(MeasureDtoToMeasure.setCommonProperties(Measure.newMeasureBuilder(), measureDto).createNoValue());
    }

    private static Measure.NewMeasureBuilder setCommonProperties(Measure.NewMeasureBuilder builder, MeasureDto measureDto) {
        Optional<Measure.Level> qualityGateStatus;
        if (measureDto.getAlertStatus() != null && (qualityGateStatus = Measure.Level.toLevel(measureDto.getAlertStatus())).isPresent()) {
            builder.setQualityGateStatus(new QualityGateStatus(qualityGateStatus.get(), measureDto.getAlertText()));
        }
        if (MeasureDtoToMeasure.hasAnyVariation(measureDto)) {
            builder.setVariation(measureDto.getVariation());
        }
        return builder;
    }

    private static boolean hasAnyVariation(MeasureDto measureDto) {
        return measureDto.getVariation() != null;
    }
}

