/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.measure;

import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.ce.task.projectanalysis.component.Developer;

@Immutable
public final class MeasureKey {
    private final String metricKey;
    @CheckForNull
    private final Developer developer;

    public MeasureKey(String metricKey, @Nullable Developer developer) {
        this.metricKey = Objects.requireNonNull(metricKey, "MetricKey can not be null");
        this.developer = developer;
    }

    public String getMetricKey() {
        return this.metricKey;
    }

    @CheckForNull
    public Developer getDeveloper() {
        return this.developer;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeasureKey that = (MeasureKey)o;
        return this.metricKey.equals(that.metricKey) && this.developer == that.developer;
    }

    public int hashCode() {
        return Objects.hash(this.metricKey);
    }

    public String toString() {
        return "MeasureKey{metricKey='" + this.metricKey + '\'' + ", developer=" + this.developer + '}';
    }
}

