/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.qualitymodel;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.sonar.api.ce.measure.Issue;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.DateUtils;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.PathAwareVisitor;
import org.sonar.ce.task.projectanalysis.component.PathAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.formula.counter.RatingValue;
import org.sonar.ce.task.projectanalysis.issue.ComponentIssuesRepository;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.projectanalysis.period.Period;
import org.sonar.ce.task.projectanalysis.period.PeriodHolder;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.server.measure.Rating;

public class NewReliabilityAndSecurityRatingMeasuresVisitor
extends PathAwareVisitorAdapter<Counter> {
    private static final Map<String, Rating> RATING_BY_SEVERITY = ImmutableMap.of((Object)"BLOCKER", (Object)Rating.E, (Object)"CRITICAL", (Object)Rating.D, (Object)"MAJOR", (Object)Rating.C, (Object)"MINOR", (Object)Rating.B, (Object)"INFO", (Object)Rating.A);
    private final MeasureRepository measureRepository;
    private final ComponentIssuesRepository componentIssuesRepository;
    private final PeriodHolder periodHolder;
    private final Map<String, Metric> metricsByKey;
    private final AnalysisMetadataHolder analysisMetadataHolder;

    public NewReliabilityAndSecurityRatingMeasuresVisitor(MetricRepository metricRepository, MeasureRepository measureRepository, ComponentIssuesRepository componentIssuesRepository, PeriodHolder periodHolder, AnalysisMetadataHolder analysisMetadataHolder) {
        super(CrawlerDepthLimit.LEAVES, ComponentVisitor.Order.POST_ORDER, CounterFactory.INSTANCE);
        this.measureRepository = measureRepository;
        this.componentIssuesRepository = componentIssuesRepository;
        this.periodHolder = periodHolder;
        this.metricsByKey = ImmutableMap.of((Object)"new_reliability_rating", (Object)metricRepository.getByKey("new_reliability_rating"), (Object)"new_security_rating", (Object)metricRepository.getByKey("new_security_rating"));
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    @Override
    public void visitProject(Component project, PathAwareVisitor.Path<Counter> path) {
        this.computeAndSaveMeasures(project, path);
    }

    @Override
    public void visitDirectory(Component directory, PathAwareVisitor.Path<Counter> path) {
        this.computeAndSaveMeasures(directory, path);
    }

    @Override
    public void visitFile(Component file, PathAwareVisitor.Path<Counter> path) {
        this.computeAndSaveMeasures(file, path);
    }

    private void computeAndSaveMeasures(Component component, PathAwareVisitor.Path<Counter> path) {
        if (!this.periodHolder.hasPeriod() && !this.analysisMetadataHolder.isSLBorPR()) {
            return;
        }
        NewReliabilityAndSecurityRatingMeasuresVisitor.initRatingsToA(path);
        this.processIssues(component, path);
        path.current().newRatingValueByMetric.entrySet().stream().filter(entry -> ((RatingValue)entry.getValue()).isSet()).forEach(entry -> this.measureRepository.add(component, this.metricsByKey.get(entry.getKey()), Measure.newMeasureBuilder().setVariation(((RatingValue)entry.getValue()).getValue().getIndex()).createNoValue()));
        NewReliabilityAndSecurityRatingMeasuresVisitor.addToParent(path);
    }

    private static void initRatingsToA(PathAwareVisitor.Path<Counter> path) {
        path.current().newRatingValueByMetric.values().forEach(entry -> entry.increment(Rating.A));
    }

    private void processIssues(Component component, PathAwareVisitor.Path<Counter> path) {
        this.componentIssuesRepository.getIssues(component).stream().filter(issue -> issue.resolution() == null).filter(issue -> issue.type().equals((Object)RuleType.BUG) || issue.type().equals((Object)RuleType.VULNERABILITY)).forEach(issue -> ((Counter)path.current()).processIssue((Issue)issue, this.analysisMetadataHolder.isSLBorPR(), this.periodHolder));
    }

    private static void addToParent(PathAwareVisitor.Path<Counter> path) {
        if (!path.isRoot()) {
            path.parent().add(path.current());
        }
    }

    private static final class CounterFactory
    extends PathAwareVisitorAdapter.SimpleStackElementFactory<Counter> {
        public static final CounterFactory INSTANCE = new CounterFactory();

        private CounterFactory() {
        }

        @Override
        public Counter createForAny(Component component) {
            return new Counter();
        }
    }

    static final class Counter {
        private Map<String, RatingValue> newRatingValueByMetric = ImmutableMap.of((Object)"new_reliability_rating", (Object)new RatingValue(), (Object)"new_security_rating", (Object)new RatingValue());

        private Counter() {
        }

        void add(Counter otherCounter) {
            this.newRatingValueByMetric.forEach((metric, rating) -> rating.increment(otherCounter.newRatingValueByMetric.get(metric)));
        }

        void processIssue(Issue issue, boolean isSLBorPR, PeriodHolder periodHolder) {
            if (isSLBorPR || Counter.isOnPeriod((DefaultIssue)issue, periodHolder.getPeriod())) {
                Rating rating = (Rating)RATING_BY_SEVERITY.get(issue.severity());
                if (issue.type().equals((Object)RuleType.BUG)) {
                    this.newRatingValueByMetric.get("new_reliability_rating").increment(rating);
                } else if (issue.type().equals((Object)RuleType.VULNERABILITY)) {
                    this.newRatingValueByMetric.get("new_security_rating").increment(rating);
                }
            }
        }

        private static boolean isOnPeriod(DefaultIssue issue, Period period) {
            return issue.creationDate().getTime() > DateUtils.truncateToSeconds((long)period.getSnapshotDate());
        }
    }
}

