/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.qualitymodel;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.sonar.api.rules.RuleType;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.PathAwareVisitor;
import org.sonar.ce.task.projectanalysis.component.PathAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.formula.counter.RatingValue;
import org.sonar.ce.task.projectanalysis.issue.ComponentIssuesRepository;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.measure.Rating;

public class ReliabilityAndSecurityRatingMeasuresVisitor
extends PathAwareVisitorAdapter<Counter> {
    private final MeasureRepository measureRepository;
    private final ComponentIssuesRepository componentIssuesRepository;
    private final Map<String, Metric> metricsByKey;

    public ReliabilityAndSecurityRatingMeasuresVisitor(MetricRepository metricRepository, MeasureRepository measureRepository, ComponentIssuesRepository componentIssuesRepository) {
        super(CrawlerDepthLimit.FILE, ComponentVisitor.Order.POST_ORDER, CounterFactory.INSTANCE);
        this.measureRepository = measureRepository;
        this.componentIssuesRepository = componentIssuesRepository;
        Metric reliabilityRatingMetric = metricRepository.getByKey("reliability_rating");
        Metric securityRatingMetric = metricRepository.getByKey("security_rating");
        this.metricsByKey = ImmutableMap.of((Object)"reliability_rating", (Object)reliabilityRatingMetric, (Object)"security_rating", (Object)securityRatingMetric);
    }

    @Override
    public void visitProject(Component project, PathAwareVisitor.Path<Counter> path) {
        this.computeAndSaveMeasures(project, path);
    }

    @Override
    public void visitDirectory(Component directory, PathAwareVisitor.Path<Counter> path) {
        this.computeAndSaveMeasures(directory, path);
    }

    @Override
    public void visitFile(Component file, PathAwareVisitor.Path<Counter> path) {
        this.computeAndSaveMeasures(file, path);
    }

    private void computeAndSaveMeasures(Component component, PathAwareVisitor.Path<Counter> path) {
        this.processIssues(component, path);
        path.current().ratingValueByMetric.forEach((key, value) -> {
            Rating rating = value.getValue();
            this.measureRepository.add(component, this.metricsByKey.get(key), Measure.newMeasureBuilder().create(rating.getIndex(), rating.name()));
        });
        if (!path.isRoot()) {
            path.parent().add(path.current());
        }
    }

    private void processIssues(Component component, PathAwareVisitor.Path<Counter> path) {
        this.componentIssuesRepository.getIssues(component).stream().filter(issue -> issue.resolution() == null).forEach(issue -> {
            Rating rating = (Rating)Rating.RATING_BY_SEVERITY.get(issue.severity());
            if (issue.type().equals((Object)RuleType.BUG)) {
                ((RatingValue)((Counter)path.current()).ratingValueByMetric.get("reliability_rating")).increment(rating);
            } else if (issue.type().equals((Object)RuleType.VULNERABILITY)) {
                ((RatingValue)((Counter)path.current()).ratingValueByMetric.get("security_rating")).increment(rating);
            }
        });
    }

    private static final class CounterFactory
    extends PathAwareVisitorAdapter.SimpleStackElementFactory<Counter> {
        public static final CounterFactory INSTANCE = new CounterFactory();

        private CounterFactory() {
        }

        @Override
        public Counter createForAny(Component component) {
            return new Counter();
        }
    }

    static final class Counter {
        private Map<String, RatingValue> ratingValueByMetric = ImmutableMap.of((Object)"reliability_rating", (Object)new RatingValue(), (Object)"security_rating", (Object)new RatingValue());

        private Counter() {
        }

        void add(Counter otherCounter) {
            this.ratingValueByMetric.forEach((key, value) -> value.increment(otherCounter.ratingValueByMetric.get(key)));
        }
    }
}

