/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.source;

import java.util.HashMap;
import java.util.Map;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.source.LineHashVersion;

public class DbLineHashVersion {
    private final Map<Component, LineHashVersion> lineHashVersionPerComponent = new HashMap<Component, LineHashVersion>();
    private final DbClient dbClient;

    public DbLineHashVersion(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public boolean hasLineHashesWithSignificantCode(Component component) {
        return this.lineHashVersionPerComponent.computeIfAbsent(component, this::compute) == LineHashVersion.WITH_SIGNIFICANT_CODE;
    }

    private LineHashVersion compute(Component component) {
        try (DbSession session = this.dbClient.openSession(false);){
            LineHashVersion lineHashVersion = this.dbClient.fileSourceDao().selectLineHashesVersion(session, component.getUuid());
            return lineHashVersion;
        }
    }
}

