/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.source;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.utils.System2;
import org.sonar.ce.task.log.CeTaskMessages;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.source.linereader.LineReader;

public class FileSourceDataWarnings {
    private static final Comparator<Component> COMPONENT_COMPARATOR = Comparator.comparingInt(t -> t.getReportAttributes().getRef());
    private final CeTaskMessages taskMessages;
    private final System2 system2;
    private final EnumMap<LineReader.Data, Set<Component>> fileErrorsPerData = new EnumMap(LineReader.Data.class);
    private boolean closed = false;

    public FileSourceDataWarnings(CeTaskMessages taskMessages, System2 system2) {
        this.taskMessages = taskMessages;
        this.system2 = system2;
    }

    public void addWarning(Component file, LineReader.ReadError readError) {
        this.checkNotCommitted();
        Objects.requireNonNull(file, "file can't be null");
        Objects.requireNonNull(readError, "readError can't be null");
        this.fileErrorsPerData.compute(readError.getData(), (data, existingList) -> {
            Set res = existingList == null ? new HashSet() : existingList;
            res.add(file);
            return res;
        });
    }

    public void commitWarnings() {
        this.checkNotCommitted();
        this.closed = true;
        this.createWarning(LineReader.Data.HIGHLIGHTING, "highlighting");
        this.createWarning(LineReader.Data.SYMBOLS, "symbol");
    }

    private void createWarning(LineReader.Data data, String dataWording) {
        Set<Component> filesWithErrors = this.fileErrorsPerData.get((Object)data);
        if (filesWithErrors == null) {
            return;
        }
        this.taskMessages.add(new CeTaskMessages.Message(FileSourceDataWarnings.computeMessage(dataWording, filesWithErrors), this.system2.now()));
    }

    private static String computeMessage(String dataWording, Set<Component> filesWithErrors) {
        if (filesWithErrors.size() == 1) {
            Component file = filesWithErrors.iterator().next();
            return String.format("Inconsistent %s data detected on file '%s'. File source may have been modified while analysis was running.", dataWording, file.getName());
        }
        String lineHeader = "\n   \u00b0 ";
        return String.format("Inconsistent %s data detected on some files (%s in total). File source may have been modified while analysis was running.", dataWording, filesWithErrors.size()) + filesWithErrors.stream().sorted(COMPONENT_COMPARATOR).limit(5L).map(Component::getName).collect(Collectors.joining(lineHeader, lineHeader, ""));
    }

    private void checkNotCommitted() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"warnings already commit");
    }
}

