/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.source.linereader;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.ce.task.projectanalysis.duplication.Duplication;
import org.sonar.ce.task.projectanalysis.duplication.InnerDuplicate;
import org.sonar.ce.task.projectanalysis.duplication.TextBlock;
import org.sonar.ce.task.projectanalysis.source.linereader.LineReader;
import org.sonar.db.protobuf.DbFileSources;

public class DuplicationLineReader
implements LineReader {
    private final Map<TextBlock, Integer> duplicatedTextBlockIndexByTextBlock;

    public DuplicationLineReader(Iterable<Duplication> duplications) {
        this.duplicatedTextBlockIndexByTextBlock = DuplicationLineReader.createIndexOfDuplicatedTextBlocks(duplications);
    }

    @Override
    public Optional<LineReader.ReadError> read(DbFileSources.Line.Builder lineBuilder) {
        TextBlockContainsLine containsLine = new TextBlockContainsLine(lineBuilder.getLine());
        this.duplicatedTextBlockIndexByTextBlock.entrySet().stream().filter(containsLine).map(Map.Entry::getValue).sorted(Comparator.naturalOrder()).forEach(arg_0 -> ((DbFileSources.Line.Builder)lineBuilder).addDuplication(arg_0));
        return Optional.empty();
    }

    private static Map<TextBlock, Integer> createIndexOfDuplicatedTextBlocks(Iterable<Duplication> duplications) {
        return DuplicationLineReader.extractAllDuplicatedTextBlocks(duplications).stream().sorted().collect(Collectors.toMap(e -> e, new TextBlockIndexGenerator(), (a, b) -> a, LinkedHashMap::new));
    }

    private static List<TextBlock> extractAllDuplicatedTextBlocks(Iterable<Duplication> duplications) {
        ArrayList<TextBlock> duplicatedBlock = new ArrayList<TextBlock>(Iterables.size(duplications));
        for (Duplication duplication : duplications) {
            duplicatedBlock.add(duplication.getOriginal());
            for (InnerDuplicate duplicate : FluentIterable.from(duplication.getDuplicates()).filter(InnerDuplicate.class)) {
                duplicatedBlock.add(duplicate.getTextBlock());
            }
        }
        return duplicatedBlock;
    }

    private static class TextBlockIndexGenerator
    implements Function<TextBlock, Integer> {
        int i = 1;

        private TextBlockIndexGenerator() {
        }

        @Override
        @Nullable
        public Integer apply(TextBlock input) {
            return this.i++;
        }
    }

    private static class TextBlockContainsLine
    implements Predicate<Map.Entry<TextBlock, Integer>> {
        private final int line;

        public TextBlockContainsLine(int line) {
            this.line = line;
        }

        @Override
        public boolean test(@Nonnull Map.Entry<TextBlock, Integer> input) {
            return TextBlockContainsLine.isLineInBlock(input.getKey(), this.line);
        }

        private static boolean isLineInBlock(TextBlock range, int line) {
            return line >= range.getStart() && line <= range.getEnd();
        }
    }
}

