/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.ce.task.projectanalysis.analysis.Analysis;
import org.sonar.ce.task.projectanalysis.analysis.Branch;
import org.sonar.ce.task.projectanalysis.analysis.MutableAnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.batch.BatchReportReader;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentKeyGenerator;
import org.sonar.ce.task.projectanalysis.component.ComponentTreeBuilder;
import org.sonar.ce.task.projectanalysis.component.ComponentUuidFactoryWithMigration;
import org.sonar.ce.task.projectanalysis.component.DefaultBranchImpl;
import org.sonar.ce.task.projectanalysis.component.MutableTreeRootHolder;
import org.sonar.ce.task.projectanalysis.component.ProjectAttributes;
import org.sonar.ce.task.projectanalysis.component.ReportModulesPath;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.SnapshotDto;
import org.sonar.scanner.protocol.output.ScannerReport;

public class BuildComponentTreeStep
implements ComputationStep {
    private static final String DEFAULT_PROJECT_VERSION = "not provided";
    private final DbClient dbClient;
    private final BatchReportReader reportReader;
    private final MutableTreeRootHolder treeRootHolder;
    private final MutableAnalysisMetadataHolder analysisMetadataHolder;
    private final ReportModulesPath reportModulesPath;

    public BuildComponentTreeStep(DbClient dbClient, BatchReportReader reportReader, MutableTreeRootHolder treeRootHolder, MutableAnalysisMetadataHolder analysisMetadataHolder, ReportModulesPath reportModulesPath) {
        this.dbClient = dbClient;
        this.reportReader = reportReader;
        this.treeRootHolder = treeRootHolder;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.reportModulesPath = reportModulesPath;
    }

    public String getDescription() {
        return "Build tree of components";
    }

    public void execute(ComputationStep.Context context) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ScannerReport.Component reportProject = this.reportReader.readComponent(this.analysisMetadataHolder.getRootComponentRef());
            ComponentKeyGenerator keyGenerator = this.loadKeyGenerator();
            ComponentKeyGenerator publicKeyGenerator = this.loadPublicKeyGenerator();
            ScannerReport.Metadata metadata = this.reportReader.readMetadata();
            String rootKey = keyGenerator.generateKey(reportProject.getKey(), null);
            Function<String, String> pathToKey = path -> keyGenerator.generateKey(reportProject.getKey(), (String)path);
            ComponentUuidFactoryWithMigration componentUuidFactoryWithMigration = new ComponentUuidFactoryWithMigration(this.dbClient, dbSession, rootKey, pathToKey, (Map<String, String>)this.reportModulesPath.get());
            String rootUuid = componentUuidFactoryWithMigration.getOrCreateForKey(rootKey);
            Optional baseAnalysis = this.dbClient.snapshotDao().selectLastAnalysisByRootComponentUuid(dbSession, rootUuid);
            ComponentTreeBuilder builder = new ComponentTreeBuilder(keyGenerator, publicKeyGenerator, componentUuidFactoryWithMigration::getOrCreateForKey, this.reportReader::readComponent, this.analysisMetadataHolder.getProject(), this.analysisMetadataHolder.getBranch(), BuildComponentTreeStep.createProjectAttributes(metadata, baseAnalysis.orElse(null)));
            String relativePathFromScmRoot = metadata.getRelativePathFromScmRoot();
            Component reportTreeRoot = builder.buildProject(reportProject, relativePathFromScmRoot);
            if (this.analysisMetadataHolder.isSLBorPR()) {
                Component changedComponentTreeRoot = builder.buildChangedComponentTreeRoot(reportTreeRoot);
                this.treeRootHolder.setRoots(changedComponentTreeRoot, reportTreeRoot);
            } else {
                this.treeRootHolder.setRoots(reportTreeRoot, reportTreeRoot);
            }
            this.analysisMetadataHolder.setBaseAnalysis(baseAnalysis.map(BuildComponentTreeStep::toAnalysis).orElse(null));
            context.getStatistics().add("components", (Object)this.treeRootHolder.getSize());
        }
    }

    private static ProjectAttributes createProjectAttributes(ScannerReport.Metadata metadata, @Nullable SnapshotDto baseAnalysis) {
        String projectVersion = BuildComponentTreeStep.computeProjectVersion(StringUtils.trimToNull((String)metadata.getProjectVersion()), baseAnalysis);
        String buildString = StringUtils.trimToNull((String)metadata.getBuildString());
        return new ProjectAttributes(projectVersion, buildString);
    }

    private static String computeProjectVersion(@Nullable String projectVersion, @Nullable SnapshotDto baseAnalysis) {
        if (projectVersion != null) {
            return projectVersion;
        }
        if (baseAnalysis != null) {
            return (String)MoreObjects.firstNonNull((Object)baseAnalysis.getProjectVersion(), (Object)DEFAULT_PROJECT_VERSION);
        }
        return DEFAULT_PROJECT_VERSION;
    }

    private ComponentKeyGenerator loadKeyGenerator() {
        return this.analysisMetadataHolder.getBranch();
    }

    private ComponentKeyGenerator loadPublicKeyGenerator() {
        Branch branch = this.analysisMetadataHolder.getBranch();
        if (!branch.isLegacyFeature() && !branch.isMain()) {
            return new DefaultBranchImpl();
        }
        return branch;
    }

    private static Analysis toAnalysis(SnapshotDto dto) {
        return new Analysis.Builder().setId(dto.getId()).setUuid(dto.getUuid()).setCreatedAt(dto.getCreatedAt()).build();
    }
}

