/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.PathAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.formula.Counter;
import org.sonar.ce.task.projectanalysis.formula.CounterInitializationContext;
import org.sonar.ce.task.projectanalysis.formula.CreateMeasureContext;
import org.sonar.ce.task.projectanalysis.formula.Formula;
import org.sonar.ce.task.projectanalysis.formula.FormulaExecutorComponentVisitor;
import org.sonar.ce.task.projectanalysis.formula.counter.IntSumCounter;
import org.sonar.ce.task.projectanalysis.formula.counter.SumCounter;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.step.ComputationStep;

public class CommentMeasuresStep
implements ComputationStep {
    private final TreeRootHolder treeRootHolder;
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;
    private final ImmutableList<Formula> formulas;

    public CommentMeasuresStep(TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository) {
        this.treeRootHolder = treeRootHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
        this.formulas = ImmutableList.of((Object)new DocumentationFormula(), (Object)new CommentDensityFormula());
    }

    public void execute(ComputationStep.Context context) {
        new PathAwareCrawler<FormulaExecutorComponentVisitor.Counters>(FormulaExecutorComponentVisitor.newBuilder(this.metricRepository, this.measureRepository).buildFor((Iterable<Formula>)this.formulas)).visit(this.treeRootHolder.getRoot());
    }

    public String getDescription() {
        return "Compute comment measures";
    }

    private static class DocumentationCounter
    implements Counter<DocumentationCounter> {
        private final SumCounter publicApiCounter = new IntSumCounter("public_api");
        private final SumCounter publicUndocumentedApiCounter = new IntSumCounter("public_undocumented_api");

        @Override
        public void aggregate(DocumentationCounter counter) {
            this.publicApiCounter.aggregate(counter.publicApiCounter);
            this.publicUndocumentedApiCounter.aggregate(counter.publicUndocumentedApiCounter);
        }

        @Override
        public void initialize(CounterInitializationContext context) {
            this.publicApiCounter.initialize(context);
            this.publicUndocumentedApiCounter.initialize(context);
        }

        public Optional<Integer> getPublicApiValue() {
            return this.publicApiCounter.getValue();
        }

        public Optional<Integer> getPublicUndocumentedApiValue() {
            return this.publicUndocumentedApiCounter.getValue();
        }
    }

    private static class DocumentationFormula
    implements Formula<DocumentationCounter> {
        private DocumentationFormula() {
        }

        @Override
        public DocumentationCounter createNewCounter() {
            return new DocumentationCounter();
        }

        @Override
        public Optional<Measure> createMeasure(DocumentationCounter counter, CreateMeasureContext context) {
            Optional<Measure> measure = DocumentationFormula.getMeasure(context, counter.getPublicApiValue(), "public_api");
            if (measure.isPresent()) {
                return measure;
            }
            measure = DocumentationFormula.getMeasure(context, counter.getPublicUndocumentedApiValue(), "public_undocumented_api");
            return measure.isPresent() ? measure : DocumentationFormula.getDensityMeasure(counter, context);
        }

        private static Optional<Measure> getMeasure(CreateMeasureContext context, Optional<Integer> metricValue, String metricKey) {
            if (context.getMetric().getKey().equals(metricKey) && metricValue.isPresent() && CrawlerDepthLimit.LEAVES.isDeeperThan(context.getComponent().getType())) {
                return Optional.of(Measure.newMeasureBuilder().create(metricValue.get()));
            }
            return Optional.empty();
        }

        private static Optional<Measure> getDensityMeasure(DocumentationCounter counter, CreateMeasureContext context) {
            if (context.getMetric().getKey().equals("public_documented_api_density") && counter.getPublicApiValue().isPresent() && counter.getPublicUndocumentedApiValue().isPresent()) {
                double publicApis = counter.getPublicApiValue().get().intValue();
                double publicUndocumentedApis = counter.getPublicUndocumentedApiValue().get().intValue();
                if (publicApis > 0.0) {
                    double documentedAPI = publicApis - publicUndocumentedApis;
                    double value = 100.0 * (documentedAPI / publicApis);
                    return Optional.of(Measure.newMeasureBuilder().create(value, context.getMetric().getDecimalScale()));
                }
            }
            return Optional.empty();
        }

        @Override
        public String[] getOutputMetricKeys() {
            return new String[]{"public_api", "public_undocumented_api", "public_documented_api_density"};
        }
    }

    private class CommentDensityFormula
    implements Formula<IntSumCounter> {
        private final Metric nclocMetric;

        public CommentDensityFormula() {
            this.nclocMetric = CommentMeasuresStep.this.metricRepository.getByKey("ncloc");
        }

        @Override
        public IntSumCounter createNewCounter() {
            return new IntSumCounter("comment_lines");
        }

        @Override
        public Optional<Measure> createMeasure(IntSumCounter counter, CreateMeasureContext context) {
            Optional<Measure> measure = this.createCommentLinesMeasure(counter, context);
            return measure.isPresent() ? measure : this.createCommentLinesDensityMeasure(counter, context);
        }

        private Optional<Measure> createCommentLinesMeasure(SumCounter counter, CreateMeasureContext context) {
            Optional commentLines = counter.getValue();
            if ("comment_lines".equals(context.getMetric().getKey()) && commentLines.isPresent() && CrawlerDepthLimit.LEAVES.isDeeperThan(context.getComponent().getType())) {
                return Optional.of(Measure.newMeasureBuilder().create((Integer)commentLines.get()));
            }
            return Optional.empty();
        }

        private Optional<Measure> createCommentLinesDensityMeasure(SumCounter counter, CreateMeasureContext context) {
            if ("comment_lines_density".equals(context.getMetric().getKey())) {
                double comments;
                double nclocs;
                double divisor;
                Optional<Measure> nclocsOpt = CommentMeasuresStep.this.measureRepository.getRawMeasure(context.getComponent(), this.nclocMetric);
                Optional commentsOpt = counter.getValue();
                if (nclocsOpt.isPresent() && commentsOpt.isPresent() && (divisor = (nclocs = (double)nclocsOpt.get().getIntValue()) + (comments = (double)((Integer)commentsOpt.get()).intValue())) > 0.0) {
                    double value = 100.0 * (comments / divisor);
                    return Optional.of(Measure.newMeasureBuilder().create(value, context.getMetric().getDecimalScale()));
                }
            }
            return Optional.empty();
        }

        @Override
        public String[] getOutputMetricKeys() {
            return new String[]{"comment_lines", "comment_lines_density"};
        }
    }
}

