/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import com.google.common.collect.ImmutableList;
import org.sonar.ce.task.projectanalysis.component.PathAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.formula.AverageFormula;
import org.sonar.ce.task.projectanalysis.formula.DistributionFormula;
import org.sonar.ce.task.projectanalysis.formula.Formula;
import org.sonar.ce.task.projectanalysis.formula.FormulaExecutorComponentVisitor;
import org.sonar.ce.task.projectanalysis.formula.SumFormula;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.step.ComputationStep;

public class ComplexityMeasuresStep
implements ComputationStep {
    private static final ImmutableList<Formula> FORMULAS = ImmutableList.of((Object)SumFormula.createIntSumFormula("complexity"), (Object)SumFormula.createIntSumFormula("complexity_in_classes"), (Object)SumFormula.createIntSumFormula("complexity_in_functions"), (Object)SumFormula.createIntSumFormula("cognitive_complexity"), (Object)new DistributionFormula("function_complexity_distribution"), (Object)new DistributionFormula("file_complexity_distribution"), (Object)AverageFormula.Builder.newBuilder().setOutputMetricKey("file_complexity").setMainMetricKey("complexity").setByMetricKey("files").build(), (Object)AverageFormula.Builder.newBuilder().setOutputMetricKey("class_complexity").setMainMetricKey("complexity_in_classes").setByMetricKey("classes").build(), (Object)AverageFormula.Builder.newBuilder().setOutputMetricKey("function_complexity").setMainMetricKey("complexity_in_functions").setByMetricKey("functions").build());
    private final TreeRootHolder treeRootHolder;
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;

    public ComplexityMeasuresStep(TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository) {
        this.treeRootHolder = treeRootHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
    }

    public void execute(ComputationStep.Context context) {
        new PathAwareCrawler<FormulaExecutorComponentVisitor.Counters>(FormulaExecutorComponentVisitor.newBuilder(this.metricRepository, this.measureRepository).buildFor((Iterable<Formula>)FORMULAS)).visit(this.treeRootHolder.getRoot());
    }

    public String getDescription() {
        return "Compute complexity measures";
    }
}

