/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import com.google.common.collect.Iterables;
import org.apache.commons.lang.StringEscapeUtils;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.duplication.CrossProjectDuplicate;
import org.sonar.ce.task.projectanalysis.duplication.Duplicate;
import org.sonar.ce.task.projectanalysis.duplication.Duplication;
import org.sonar.ce.task.projectanalysis.duplication.DuplicationRepository;
import org.sonar.ce.task.projectanalysis.duplication.InExtendedProjectDuplicate;
import org.sonar.ce.task.projectanalysis.duplication.InProjectDuplicate;
import org.sonar.ce.task.projectanalysis.duplication.InnerDuplicate;
import org.sonar.ce.task.projectanalysis.duplication.TextBlock;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.step.ComputationStep;

public class DuplicationDataMeasuresStep
implements ComputationStep {
    private final MeasureRepository measureRepository;
    private final TreeRootHolder treeRootHolder;
    private final DuplicationRepository duplicationRepository;
    private final Metric duplicationDataMetric;

    public DuplicationDataMeasuresStep(TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository, DuplicationRepository duplicationRepository) {
        this.measureRepository = measureRepository;
        this.treeRootHolder = treeRootHolder;
        this.duplicationRepository = duplicationRepository;
        this.duplicationDataMetric = metricRepository.getByKey("duplications_data");
    }

    public void execute(ComputationStep.Context context) {
        new DepthTraversalTypeAwareCrawler(new DuplicationVisitor()).visit(this.treeRootHolder.getRoot());
    }

    public String getDescription() {
        return "Compute duplication data measures";
    }

    private class DuplicationVisitor
    extends TypeAwareVisitorAdapter {
        private DuplicationVisitor() {
            super(CrawlerDepthLimit.FILE, ComponentVisitor.Order.PRE_ORDER);
        }

        @Override
        public void visitFile(Component file) {
            Iterable<Duplication> duplications = DuplicationDataMeasuresStep.this.duplicationRepository.getDuplications(file);
            if (!Iterables.isEmpty(duplications)) {
                this.computeDuplications(file, duplications);
            }
        }

        private void computeDuplications(Component component, Iterable<Duplication> duplications) {
            String duplicationXml = this.createXmlDuplications(component.getDbKey(), duplications);
            DuplicationDataMeasuresStep.this.measureRepository.add(component, DuplicationDataMeasuresStep.this.duplicationDataMetric, Measure.newMeasureBuilder().create(duplicationXml));
        }

        private String createXmlDuplications(String componentDbKey, Iterable<Duplication> duplications) {
            StringBuilder xml = new StringBuilder();
            xml.append("<duplications>");
            for (Duplication duplication : duplications) {
                xml.append("<g>");
                this.appendDuplication(xml, componentDbKey, duplication.getOriginal(), false);
                for (Duplicate duplicate : duplication.getDuplicates()) {
                    this.processDuplicationBlock(xml, duplicate, componentDbKey);
                }
                xml.append("</g>");
            }
            xml.append("</duplications>");
            return xml.toString();
        }

        private void processDuplicationBlock(StringBuilder xml, Duplicate duplicate, String componentDbKey) {
            if (duplicate instanceof InnerDuplicate) {
                this.appendDuplication(xml, componentDbKey, duplicate);
            } else if (duplicate instanceof InExtendedProjectDuplicate) {
                this.appendDuplication(xml, ((InExtendedProjectDuplicate)duplicate).getFile().getDbKey(), duplicate.getTextBlock(), true);
            } else if (duplicate instanceof InProjectDuplicate) {
                this.appendDuplication(xml, ((InProjectDuplicate)duplicate).getFile().getDbKey(), duplicate);
            } else if (duplicate instanceof CrossProjectDuplicate) {
                String crossProjectComponentKey = ((CrossProjectDuplicate)duplicate).getFileKey();
                this.appendDuplication(xml, crossProjectComponentKey, duplicate);
            } else {
                throw new IllegalArgumentException("Unsupported type of Duplicate " + duplicate.getClass().getName());
            }
        }

        private void appendDuplication(StringBuilder xml, String componentDbKey, Duplicate duplicate) {
            this.appendDuplication(xml, componentDbKey, duplicate.getTextBlock(), false);
        }

        private void appendDuplication(StringBuilder xml, String componentDbKey, TextBlock textBlock, boolean disableLink) {
            int length = textBlock.getEnd() - textBlock.getStart() + 1;
            xml.append("<b s=\"").append(textBlock.getStart()).append("\" l=\"").append(length).append("\" t=\"").append(disableLink).append("\" r=\"").append(StringEscapeUtils.escapeXml((String)componentDbKey)).append("\"/>");
        }
    }
}

