/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import java.util.ArrayList;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.batch.BatchReportReader;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.core.util.CloseableIterator;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.AnalysisPropertyDto;
import org.sonar.scanner.protocol.output.ScannerReport;

public class PersistAnalysisPropertiesStep
implements ComputationStep {
    private static final String SONAR_PULL_REQUEST = "sonar.pullrequest.";
    private static final String SCM_REVISION_ID = "sonar.analysis.scm_revision_id";
    private final DbClient dbClient;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final BatchReportReader reportReader;
    private final UuidFactory uuidFactory;

    public PersistAnalysisPropertiesStep(DbClient dbClient, AnalysisMetadataHolder analysisMetadataHolder, BatchReportReader reportReader, UuidFactory uuidFactory) {
        this.dbClient = dbClient;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.reportReader = reportReader;
        this.uuidFactory = uuidFactory;
    }

    public void execute(ComputationStep.Context context) {
        ArrayList analysisPropertyDtos = new ArrayList();
        try (CloseableIterator<ScannerReport.ContextProperty> it = this.reportReader.readContextProperties();){
            it.forEachRemaining(contextProperty -> {
                String propertyKey = contextProperty.getKey();
                if (propertyKey.startsWith("sonar.analysis.") || propertyKey.startsWith(SONAR_PULL_REQUEST)) {
                    analysisPropertyDtos.add(new AnalysisPropertyDto().setUuid(this.uuidFactory.create()).setKey(propertyKey).setValue(contextProperty.getValue()).setSnapshotUuid(this.analysisMetadataHolder.getUuid()));
                }
            });
        }
        this.analysisMetadataHolder.getScmRevisionId().ifPresent(scmRevisionId -> analysisPropertyDtos.add(new AnalysisPropertyDto().setUuid(this.uuidFactory.create()).setKey(SCM_REVISION_ID).setValue(scmRevisionId).setSnapshotUuid(this.analysisMetadataHolder.getUuid())));
        if (analysisPropertyDtos.isEmpty()) {
            return;
        }
        var4_4 = null;
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.dbClient.analysisPropertiesDao().insert(dbSession, analysisPropertyDtos);
            dbSession.commit();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    public String getDescription() {
        return "Persist analysis properties";
    }
}

