/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.System2;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.component.BranchPersister;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.MutableDbIdsRepository;
import org.sonar.ce.task.projectanalysis.component.MutableDisabledComponentsHolder;
import org.sonar.ce.task.projectanalysis.component.PathAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.PathAwareVisitor;
import org.sonar.ce.task.projectanalysis.component.PathAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentUpdateDto;

public class PersistComponentsStep
implements ComputationStep {
    private final DbClient dbClient;
    private final TreeRootHolder treeRootHolder;
    private final MutableDbIdsRepository dbIdsRepository;
    private final System2 system2;
    private final MutableDisabledComponentsHolder disabledComponentsHolder;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final BranchPersister branchPersister;

    public PersistComponentsStep(DbClient dbClient, TreeRootHolder treeRootHolder, MutableDbIdsRepository dbIdsRepository, System2 system2, MutableDisabledComponentsHolder disabledComponentsHolder, AnalysisMetadataHolder analysisMetadataHolder, BranchPersister branchPersister) {
        this.dbClient = dbClient;
        this.treeRootHolder = treeRootHolder;
        this.dbIdsRepository = dbIdsRepository;
        this.system2 = system2;
        this.disabledComponentsHolder = disabledComponentsHolder;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.branchPersister = branchPersister;
    }

    public String getDescription() {
        return "Persist components";
    }

    public void execute(ComputationStep.Context context) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.branchPersister.persist(dbSession);
            String projectUuid = this.treeRootHolder.getRoot().getUuid();
            this.dbClient.componentDao().resetBChangedForRootComponentUuid(dbSession, projectUuid);
            Map<String, ComponentDto> existingDtosByUuids = this.indexExistingDtosByUuids(dbSession);
            boolean isRootPrivate = PersistComponentsStep.isRootPrivate(this.treeRootHolder.getRoot(), existingDtosByUuids);
            String mainBranchProjectUuid = this.loadProjectUuidOfMainBranch();
            new PathAwareCrawler<ComponentDtoHolder>(new PersistComponentStepsVisitor(existingDtosByUuids, dbSession, mainBranchProjectUuid)).visit(this.treeRootHolder.getRoot());
            this.disableRemainingComponents(dbSession, existingDtosByUuids.values());
            this.ensureConsistentVisibility(dbSession, projectUuid, isRootPrivate);
            dbSession.commit();
        }
    }

    @CheckForNull
    private String loadProjectUuidOfMainBranch() {
        if (!this.analysisMetadataHolder.getBranch().isMain()) {
            return this.analysisMetadataHolder.getProject().getUuid();
        }
        return null;
    }

    private void disableRemainingComponents(DbSession dbSession, Collection<ComponentDto> dtos) {
        Set uuids = (Set)dtos.stream().filter(ComponentDto::isEnabled).map(ComponentDto::uuid).collect(MoreCollectors.toSet((int)dtos.size()));
        this.dbClient.componentDao().updateBEnabledToFalse(dbSession, (Collection)uuids);
        this.disabledComponentsHolder.setUuids(uuids);
    }

    private void ensureConsistentVisibility(DbSession dbSession, String projectUuid, boolean isRootPrivate) {
        this.dbClient.componentDao().setPrivateForRootComponentUuid(dbSession, projectUuid, isRootPrivate);
    }

    private static boolean isRootPrivate(Component root, Map<String, ComponentDto> existingDtosByUuids) {
        ComponentDto rootDto = existingDtosByUuids.get(root.getUuid());
        if (rootDto == null) {
            if (Component.Type.VIEW == root.getType()) {
                return false;
            }
            throw new IllegalStateException(String.format("The project '%s' is not stored in the database, during a project analysis.", root.getDbKey()));
        }
        return rootDto.isPrivate();
    }

    private Map<String, ComponentDto> indexExistingDtosByUuids(DbSession session) {
        return this.dbClient.componentDao().selectAllComponentsFromProjectKey(session, this.treeRootHolder.getRoot().getDbKey()).stream().collect(Collectors.toMap(ComponentDto::uuid, Function.identity()));
    }

    private static void setParentModuleProperties(ComponentDto componentDto, PathAwareVisitor.Path<ComponentDtoHolder> path) {
        componentDto.setProjectUuid(path.root().getDto().uuid());
        ComponentDto parentModule = ((ComponentDtoHolder)((PathAwareVisitor.PathElement)FluentIterable.from(path.getCurrentPath()).filter((Predicate)ParentModulePathElement.INSTANCE).first().get()).getElement()).getDto();
        componentDto.setUuidPath(ComponentDto.formatUuidPathFromParent((ComponentDto)path.parent().getDto()));
        componentDto.setRootUuid(parentModule.uuid());
        componentDto.setModuleUuid(parentModule.uuid());
        componentDto.setModuleUuidPath(parentModule.moduleUuidPath());
    }

    private static Optional<ComponentUpdateDto> compareForUpdate(ComponentDto existing, ComponentDto target) {
        boolean hasDifferences = !StringUtils.equals((String)existing.getCopyResourceUuid(), (String)target.getCopyResourceUuid()) || !StringUtils.equals((String)existing.description(), (String)target.description()) || !StringUtils.equals((String)existing.getDbKey(), (String)target.getDbKey()) || !existing.isEnabled() || !StringUtils.equals((String)existing.getUuidPath(), (String)target.getUuidPath()) || !StringUtils.equals((String)existing.language(), (String)target.language()) || !StringUtils.equals((String)existing.longName(), (String)target.longName()) || !StringUtils.equals((String)existing.moduleUuid(), (String)target.moduleUuid()) || !StringUtils.equals((String)existing.moduleUuidPath(), (String)target.moduleUuidPath()) || !StringUtils.equals((String)existing.name(), (String)target.name()) || !StringUtils.equals((String)existing.path(), (String)target.path()) || !StringUtils.equals((String)existing.scope(), (String)target.scope()) || !StringUtils.equals((String)existing.qualifier(), (String)target.qualifier());
        ComponentUpdateDto update = null;
        if (hasDifferences) {
            update = ComponentUpdateDto.copyFrom((ComponentDto)target).setBChanged(true);
        }
        return Optional.ofNullable(update);
    }

    private static String getFileQualifier(Component component) {
        return component.getFileAttributes().isUnitTest() ? "UTS" : "FIL";
    }

    private static enum ParentModulePathElement implements Predicate<PathAwareVisitor.PathElement<ComponentDtoHolder>>
    {
        INSTANCE;


        public boolean apply(@Nonnull PathAwareVisitor.PathElement<ComponentDtoHolder> input) {
            return input.getComponent().getType() == Component.Type.PROJECT;
        }
    }

    private static class ComponentDtoHolder {
        private ComponentDto dto;

        private ComponentDtoHolder() {
        }

        public ComponentDto getDto() {
            return this.dto;
        }

        public void setDto(ComponentDto dto) {
            this.dto = dto;
        }
    }

    private class PersistComponentStepsVisitor
    extends PathAwareVisitorAdapter<ComponentDtoHolder> {
        private final Map<String, ComponentDto> existingComponentDtosByUuids;
        private final DbSession dbSession;
        @Nullable
        private final String mainBranchProjectUuid;

        PersistComponentStepsVisitor(Map<String, ComponentDto> existingComponentDtosByUuids, @Nullable DbSession dbSession, String mainBranchProjectUuid) {
            super(CrawlerDepthLimit.LEAVES, ComponentVisitor.Order.PRE_ORDER, new PathAwareVisitorAdapter.SimpleStackElementFactory<ComponentDtoHolder>(){

                @Override
                public ComponentDtoHolder createForAny(Component component) {
                    return new ComponentDtoHolder();
                }

                @Override
                public ComponentDtoHolder createForFile(Component file) {
                    return null;
                }

                @Override
                public ComponentDtoHolder createForProjectView(Component projectView) {
                    return null;
                }
            });
            this.existingComponentDtosByUuids = existingComponentDtosByUuids;
            this.dbSession = dbSession;
            this.mainBranchProjectUuid = mainBranchProjectUuid;
        }

        @Override
        public void visitProject(Component project, PathAwareVisitor.Path<ComponentDtoHolder> path) {
            ComponentDto dto = this.createForProject(project);
            path.current().setDto(this.persistAndPopulateCache(project, dto));
        }

        @Override
        public void visitDirectory(Component directory, PathAwareVisitor.Path<ComponentDtoHolder> path) {
            ComponentDto dto = this.createForDirectory(directory, path);
            path.current().setDto(this.persistAndPopulateCache(directory, dto));
        }

        @Override
        public void visitFile(Component file, PathAwareVisitor.Path<ComponentDtoHolder> path) {
            ComponentDto dto = this.createForFile(file, path);
            this.persistAndPopulateCache(file, dto);
        }

        @Override
        public void visitView(Component view, PathAwareVisitor.Path<ComponentDtoHolder> path) {
            ComponentDto dto = this.createForView(view);
            path.current().setDto(this.persistAndPopulateCache(view, dto));
        }

        @Override
        public void visitSubView(Component subView, PathAwareVisitor.Path<ComponentDtoHolder> path) {
            ComponentDto dto = this.createForSubView(subView, path);
            path.current().setDto(this.persistAndPopulateCache(subView, dto));
        }

        @Override
        public void visitProjectView(Component projectView, PathAwareVisitor.Path<ComponentDtoHolder> path) {
            ComponentDto dto = this.createForProjectView(projectView, path);
            this.persistAndPopulateCache(projectView, dto);
        }

        private ComponentDto persistAndPopulateCache(Component component, ComponentDto dto) {
            ComponentDto projectDto = this.persistComponent(dto);
            this.addToCache(component, projectDto);
            return projectDto;
        }

        private ComponentDto persistComponent(ComponentDto componentDto) {
            ComponentDto existingComponent = this.existingComponentDtosByUuids.remove(componentDto.uuid());
            if (existingComponent == null) {
                PersistComponentsStep.this.dbClient.componentDao().insert(this.dbSession, componentDto);
                return componentDto;
            }
            Optional update = PersistComponentsStep.compareForUpdate(existingComponent, componentDto);
            if (update.isPresent()) {
                ComponentUpdateDto updateDto = (ComponentUpdateDto)update.get();
                PersistComponentsStep.this.dbClient.componentDao().update(this.dbSession, updateDto);
                existingComponent.setDbKey(updateDto.getBKey());
                existingComponent.setCopyComponentUuid(updateDto.getBCopyComponentUuid());
                existingComponent.setDescription(updateDto.getBDescription());
                existingComponent.setEnabled(updateDto.isBEnabled());
                existingComponent.setUuidPath(updateDto.getBUuidPath());
                existingComponent.setLanguage(updateDto.getBLanguage());
                existingComponent.setLongName(updateDto.getBLongName());
                existingComponent.setModuleUuid(updateDto.getBModuleUuid());
                existingComponent.setModuleUuidPath(updateDto.getBModuleUuidPath());
                existingComponent.setName(updateDto.getBName());
                existingComponent.setPath(updateDto.getBPath());
                existingComponent.setScope(componentDto.scope());
                existingComponent.setQualifier(updateDto.getBQualifier());
            }
            return existingComponent;
        }

        private void addToCache(Component component, ComponentDto componentDto) {
            PersistComponentsStep.this.dbIdsRepository.setComponentId(component, componentDto.getId());
        }

        public ComponentDto createForProject(Component project) {
            ComponentDto res = this.createBase(project);
            res.setScope("PRJ");
            res.setQualifier("TRK");
            res.setName(project.getName());
            res.setLongName(res.name());
            res.setDescription(project.getDescription());
            res.setProjectUuid(res.uuid());
            res.setRootUuid(res.uuid());
            res.setUuidPath(".");
            res.setModuleUuidPath("." + res.uuid() + ".");
            return res;
        }

        public ComponentDto createForDirectory(Component directory, PathAwareVisitor.Path<ComponentDtoHolder> path) {
            ComponentDto res = this.createBase(directory);
            res.setScope("DIR");
            res.setQualifier("DIR");
            res.setName(directory.getShortName());
            res.setLongName(directory.getName());
            res.setPath(directory.getName());
            PersistComponentsStep.setParentModuleProperties(res, path);
            return res;
        }

        public ComponentDto createForFile(Component file, PathAwareVisitor.Path<ComponentDtoHolder> path) {
            ComponentDto res = this.createBase(file);
            res.setScope("FIL");
            res.setQualifier(PersistComponentsStep.getFileQualifier(file));
            res.setName(file.getShortName());
            res.setLongName(file.getName());
            res.setPath(file.getName());
            res.setLanguage(file.getFileAttributes().getLanguageKey());
            PersistComponentsStep.setParentModuleProperties(res, path);
            return res;
        }

        private ComponentDto createForView(Component view) {
            ComponentDto res = this.createBase(view);
            res.setScope("PRJ");
            res.setQualifier(view.getViewAttributes().getType().getQualifier());
            res.setName(view.getName());
            res.setDescription(view.getDescription());
            res.setLongName(res.name());
            res.setProjectUuid(res.uuid());
            res.setRootUuid(res.uuid());
            res.setUuidPath(".");
            res.setModuleUuidPath("." + res.uuid() + ".");
            return res;
        }

        private ComponentDto createForSubView(Component subView, PathAwareVisitor.Path<ComponentDtoHolder> path) {
            ComponentDto res = this.createBase(subView);
            res.setScope("PRJ");
            res.setQualifier("SVW");
            res.setName(subView.getName());
            res.setDescription(subView.getDescription());
            res.setLongName(res.name());
            res.setCopyComponentUuid(subView.getSubViewAttributes().getOriginalViewUuid());
            this.setRootAndParentModule(res, path);
            return res;
        }

        private ComponentDto createForProjectView(Component projectView, PathAwareVisitor.Path<ComponentDtoHolder> path) {
            ComponentDto res = this.createBase(projectView);
            res.setScope("FIL");
            res.setQualifier("TRK");
            res.setName(projectView.getName());
            res.setLongName(res.name());
            res.setCopyComponentUuid(projectView.getProjectViewAttributes().getProjectUuid());
            this.setRootAndParentModule(res, path);
            return res;
        }

        private ComponentDto createBase(Component component) {
            String componentKey = component.getDbKey();
            String componentUuid = component.getUuid();
            ComponentDto componentDto = new ComponentDto();
            componentDto.setOrganizationUuid(PersistComponentsStep.this.analysisMetadataHolder.getOrganization().getUuid());
            componentDto.setUuid(componentUuid);
            componentDto.setDbKey(componentKey);
            componentDto.setMainBranchProjectUuid(this.mainBranchProjectUuid);
            componentDto.setEnabled(true);
            componentDto.setCreatedAt(new Date(PersistComponentsStep.this.system2.now()));
            return componentDto;
        }

        private void setRootAndParentModule(ComponentDto res, PathAwareVisitor.Path<ComponentDtoHolder> path) {
            ComponentDto rootDto = path.root().getDto();
            res.setRootUuid(rootDto.uuid());
            res.setProjectUuid(rootDto.uuid());
            ComponentDto parentModule = path.parent().getDto();
            res.setUuidPath(ComponentDto.formatUuidPathFromParent((ComponentDto)parentModule));
            res.setModuleUuid(parentModule.uuid());
            res.setModuleUuidPath(parentModule.moduleUuidPath() + res.uuid() + ".");
        }
    }
}

