/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.batch.BatchReportReader;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.duplication.CrossProjectDuplicationStatusHolder;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.core.util.CloseableIterator;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.duplication.DuplicationUnitDto;
import org.sonar.scanner.protocol.output.ScannerReport;

public class PersistCrossProjectDuplicationIndexStep
implements ComputationStep {
    private final DbClient dbClient;
    private final TreeRootHolder treeRootHolder;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final BatchReportReader reportReader;
    private final CrossProjectDuplicationStatusHolder crossProjectDuplicationStatusHolder;

    public PersistCrossProjectDuplicationIndexStep(CrossProjectDuplicationStatusHolder crossProjectDuplicationStatusHolder, DbClient dbClient, TreeRootHolder treeRootHolder, AnalysisMetadataHolder analysisMetadataHolder, BatchReportReader reportReader) {
        this.dbClient = dbClient;
        this.treeRootHolder = treeRootHolder;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.reportReader = reportReader;
        this.crossProjectDuplicationStatusHolder = crossProjectDuplicationStatusHolder;
    }

    public void execute(ComputationStep.Context context) {
        if (!this.crossProjectDuplicationStatusHolder.isEnabled()) {
            return;
        }
        try (DbSession dbSession = this.dbClient.openSession(true);){
            Component project = this.treeRootHolder.getRoot();
            DuplicationVisitor visitor = new DuplicationVisitor(dbSession, this.analysisMetadataHolder.getUuid());
            new DepthTraversalTypeAwareCrawler(visitor).visit(project);
            dbSession.commit();
            context.getStatistics().add("inserts", (Object)visitor.count);
        }
    }

    public String getDescription() {
        return "Persist cross project duplications";
    }

    private class DuplicationVisitor
    extends TypeAwareVisitorAdapter {
        private final DbSession session;
        private final String analysisUuid;
        private int count;

        private DuplicationVisitor(DbSession session, String analysisUuid) {
            super(CrawlerDepthLimit.FILE, ComponentVisitor.Order.PRE_ORDER);
            this.count = 0;
            this.session = session;
            this.analysisUuid = analysisUuid;
        }

        @Override
        public void visitFile(Component file) {
            this.visitComponent(file);
        }

        private void visitComponent(Component component) {
            this.readFromReport(component);
        }

        private void readFromReport(Component component) {
            int indexInFile = 0;
            try (CloseableIterator<ScannerReport.CpdTextBlock> blocks = PersistCrossProjectDuplicationIndexStep.this.reportReader.readCpdTextBlocks(component.getReportAttributes().getRef());){
                while (blocks.hasNext()) {
                    ScannerReport.CpdTextBlock block = (ScannerReport.CpdTextBlock)blocks.next();
                    PersistCrossProjectDuplicationIndexStep.this.dbClient.duplicationDao().insert(this.session, new DuplicationUnitDto().setHash(block.getHash()).setStartLine(block.getStartLine()).setEndLine(block.getEndLine()).setIndexInFile(indexInFile).setAnalysisUuid(this.analysisUuid).setComponentUuid(component.getUuid()));
                    ++indexInFile;
                }
            }
            this.count += indexInFile;
        }
    }
}

