/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.measure.BestValueOptimization;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.measure.MeasureToMeasureDto;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.measure.LiveMeasureComparator;
import org.sonar.db.measure.LiveMeasureDto;

public class PersistLiveMeasuresStep
implements ComputationStep {
    private static final Set<String> NOT_TO_PERSIST_ON_FILE_METRIC_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("file_complexity_distribution", "function_complexity_distribution")));
    private final DbClient dbClient;
    private final MetricRepository metricRepository;
    private final MeasureToMeasureDto measureToMeasureDto;
    private final TreeRootHolder treeRootHolder;
    private final MeasureRepository measureRepository;

    public PersistLiveMeasuresStep(DbClient dbClient, MetricRepository metricRepository, MeasureToMeasureDto measureToMeasureDto, TreeRootHolder treeRootHolder, MeasureRepository measureRepository) {
        this.dbClient = dbClient;
        this.metricRepository = metricRepository;
        this.measureToMeasureDto = measureToMeasureDto;
        this.treeRootHolder = treeRootHolder;
        this.measureRepository = measureRepository;
    }

    public String getDescription() {
        return "Persist live measures";
    }

    public void execute(ComputationStep.Context context) {
        boolean supportUpsert = this.dbClient.getDatabase().getDialect().supportsUpsert();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Component root = this.treeRootHolder.getRoot();
            MeasureVisitor visitor = new MeasureVisitor(dbSession, supportUpsert);
            new DepthTraversalTypeAwareCrawler(visitor).visit(root);
            context.getStatistics().add("insertsOrUpdates", (Object)visitor.insertsOrUpdates);
        }
    }

    private static enum NonEmptyMeasure implements Predicate<Measure>
    {
        INSTANCE;


        @Override
        public boolean test(@Nonnull Measure input) {
            return input.getValueType() != Measure.ValueType.NO_VALUE || input.hasVariation() || input.getData() != null;
        }
    }

    private class MeasureVisitor
    extends TypeAwareVisitorAdapter {
        private final DbSession dbSession;
        private final boolean supportUpsert;
        private int insertsOrUpdates;

        private MeasureVisitor(DbSession dbSession, boolean supportUpsert) {
            super(CrawlerDepthLimit.LEAVES, ComponentVisitor.Order.PRE_ORDER);
            this.insertsOrUpdates = 0;
            this.supportUpsert = supportUpsert;
            this.dbSession = dbSession;
        }

        @Override
        public void visitAny(Component component) {
            ArrayList metricIds = new ArrayList();
            SetMultimap<String, Measure> measures = PersistLiveMeasuresStep.this.measureRepository.getRawMeasures(component);
            ArrayList dtos = new ArrayList();
            for (Map.Entry measuresByMetricKey : measures.asMap().entrySet()) {
                String metricKey = (String)measuresByMetricKey.getKey();
                if (NOT_TO_PERSIST_ON_FILE_METRIC_KEYS.contains(metricKey) && component.getType() == Component.Type.FILE) continue;
                Metric metric = PersistLiveMeasuresStep.this.metricRepository.getByKey(metricKey);
                Predicate<Measure> notBestValueOptimized = BestValueOptimization.from(metric, component).negate();
                ((Collection)measuresByMetricKey.getValue()).stream().filter(NonEmptyMeasure.INSTANCE).filter(notBestValueOptimized).map(measure -> PersistLiveMeasuresStep.this.measureToMeasureDto.toLiveMeasureDto((Measure)measure, metric, component)).sorted((Comparator<LiveMeasureDto>)LiveMeasureComparator.INSTANCE).forEach(lm -> {
                    dtos.add(lm);
                    metricIds.add(metric.getId());
                });
            }
            if (this.supportUpsert) {
                PersistLiveMeasuresStep.this.dbClient.liveMeasureDao().upsert(this.dbSession, dtos);
            } else {
                for (LiveMeasureDto dto : dtos) {
                    PersistLiveMeasuresStep.this.dbClient.liveMeasureDao().insertOrUpdate(this.dbSession, dto);
                }
            }
            this.insertsOrUpdates += dtos.size();
            PersistLiveMeasuresStep.this.dbClient.liveMeasureDao().deleteByComponentUuidExcludingMetricIds(this.dbSession, component.getUuid(), metricIds);
            this.dbSession.commit();
        }
    }
}

