/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import java.util.Collections;
import org.sonar.ce.task.CeTask;
import org.sonar.ce.task.projectanalysis.batch.BatchReportReader;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.core.util.CloseableIterator;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;

public class PersistScannerContextStep
implements ComputationStep {
    private final BatchReportReader reportReader;
    private final DbClient dbClient;
    private final CeTask ceTask;

    public PersistScannerContextStep(BatchReportReader reportReader, DbClient dbClient, CeTask ceTask) {
        this.reportReader = reportReader;
        this.dbClient = dbClient;
        this.ceTask = ceTask;
    }

    public String getDescription() {
        return "Persist scanner context";
    }

    public void execute(ComputationStep.Context context) {
        block24: {
            try (CloseableIterator<String> logsIterator = this.reportReader.readScannerLogs();){
                if (!logsIterator.hasNext()) break block24;
                try (DbSession dbSession = this.dbClient.openSession(false);){
                    this.dbClient.ceScannerContextDao().deleteByUuids(dbSession, Collections.singleton(this.ceTask.getUuid()));
                    dbSession.commit();
                    this.dbClient.ceScannerContextDao().insert(dbSession, this.ceTask.getUuid(), logsIterator);
                    dbSession.commit();
                }
            }
        }
    }
}

