/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.MessageException;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchDto;
import org.sonar.db.component.BranchType;
import org.sonar.db.component.ComponentDao;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;

public class ValidateProjectStep
implements ComputationStep {
    private static final Joiner MESSAGES_JOINER = Joiner.on((String)"\n  o ");
    private final DbClient dbClient;
    private final TreeRootHolder treeRootHolder;
    private final AnalysisMetadataHolder analysisMetadataHolder;

    public ValidateProjectStep(DbClient dbClient, TreeRootHolder treeRootHolder, AnalysisMetadataHolder analysisMetadataHolder) {
        this.dbClient = dbClient;
        this.treeRootHolder = treeRootHolder;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    public void execute(ComputationStep.Context context) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.validateTargetBranch(dbSession);
            Component root = this.treeRootHolder.getRoot();
            List baseModules = this.dbClient.componentDao().selectEnabledModulesFromProjectKey(dbSession, root.getDbKey());
            Map<String, ComponentDto> baseModulesByKey = baseModules.stream().collect(Collectors.toMap(ComponentDto::getDbKey, x -> x));
            ValidateProjectsVisitor visitor = new ValidateProjectsVisitor(dbSession, this.dbClient.componentDao(), baseModulesByKey);
            new DepthTraversalTypeAwareCrawler(visitor).visit(root);
            if (!visitor.validationMessages.isEmpty()) {
                throw MessageException.of((String)("Validation of project failed:\n  o " + MESSAGES_JOINER.join((Iterable)visitor.validationMessages)));
            }
        }
    }

    private void validateTargetBranch(DbSession session) {
        if (!this.analysisMetadataHolder.isSLBorPR()) {
            return;
        }
        String mergeBranchUuid = this.analysisMetadataHolder.getBranch().getMergeBranchUuid().get();
        int moduleCount = this.dbClient.componentDao().countEnabledModulesByProjectUuid(session, mergeBranchUuid);
        if (moduleCount > 0) {
            Optional opt = this.dbClient.branchDao().selectByUuid(session, mergeBranchUuid);
            Preconditions.checkState((boolean)opt.isPresent(), (String)"Merge branch '%s' does not exist", (Object[])new Object[]{mergeBranchUuid});
            String type = this.analysisMetadataHolder.getBranch().getType() == BranchType.PULL_REQUEST ? "pull request" : "short-lived branch";
            throw MessageException.of((String)String.format("Due to an upgrade, you need first to re-analyze the target branch '%s' before analyzing this %s.", ((BranchDto)opt.get()).getKey(), type));
        }
    }

    public String getDescription() {
        return "Validate project";
    }

    private class ValidateProjectsVisitor
    extends TypeAwareVisitorAdapter {
        private final DbSession session;
        private final ComponentDao componentDao;
        private final Map<String, ComponentDto> baseModulesByKey;
        private final List<String> validationMessages;

        public ValidateProjectsVisitor(DbSession session, ComponentDao componentDao, Map<String, ComponentDto> baseModulesByKey) {
            super(CrawlerDepthLimit.PROJECT, ComponentVisitor.Order.PRE_ORDER);
            this.validationMessages = new ArrayList<String>();
            this.session = session;
            this.componentDao = componentDao;
            this.baseModulesByKey = baseModulesByKey;
        }

        @Override
        public void visitProject(Component rawProject) {
            String rawProjectKey = rawProject.getDbKey();
            Optional<ComponentDto> baseProject = this.loadBaseComponent(rawProjectKey);
            this.validateAnalysisDate(baseProject);
        }

        private void validateAnalysisDate(Optional<ComponentDto> baseProject) {
            if (baseProject.isPresent()) {
                Optional snapshotDto = ValidateProjectStep.this.dbClient.snapshotDao().selectLastAnalysisByRootComponentUuid(this.session, baseProject.get().uuid());
                long currentAnalysisDate = ValidateProjectStep.this.analysisMetadataHolder.getAnalysisDate();
                Long lastAnalysisDate = snapshotDto.map(SnapshotDto::getCreatedAt).orElse(null);
                if (lastAnalysisDate != null && currentAnalysisDate <= lastAnalysisDate) {
                    this.validationMessages.add(String.format("Date of analysis cannot be older than the date of the last known analysis on this project. Value: \"%s\". Latest analysis: \"%s\". It's only possible to rebuild the past in a chronological order.", DateUtils.formatDateTime((Date)new Date(currentAnalysisDate)), DateUtils.formatDateTime((Date)new Date(lastAnalysisDate))));
                }
            }
        }

        private Optional<ComponentDto> loadBaseComponent(String rawComponentKey) {
            ComponentDto baseComponent = this.baseModulesByKey.get(rawComponentKey);
            if (baseComponent == null) {
                return this.componentDao.selectByKey(this.session, rawComponentKey);
            }
            return Optional.of(baseComponent);
        }
    }
}

