/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process;

import org.slf4j.LoggerFactory;
import org.sonar.process.Stoppable;
import org.sonar.process.sharedmemoryfile.ProcessCommands;

public class StopWatcher
extends Thread {
    private final ProcessCommands commands;
    private final Stoppable stoppable;
    private final long delayMs;
    private boolean watching = true;

    public StopWatcher(ProcessCommands commands, Stoppable stoppable) {
        this(commands, stoppable, 500L);
    }

    StopWatcher(ProcessCommands commands, Stoppable stoppable, long delayMs) {
        super("Stop Watcher");
        this.commands = commands;
        this.stoppable = stoppable;
        this.delayMs = delayMs;
    }

    @Override
    public void run() {
        try {
            while (this.watching) {
                if (this.commands.askedForStop()) {
                    LoggerFactory.getLogger(this.getClass()).info("Stopping process");
                    this.stoppable.stopAsync();
                    this.watching = false;
                    continue;
                }
                try {
                    Thread.sleep(this.delayMs);
                }
                catch (InterruptedException ignored) {
                    this.watching = false;
                    Thread.currentThread().interrupt();
                }
            }
        }
        finally {
            this.commands.endWatch();
        }
    }

    public void stopWatching() {
        this.watching = false;
    }
}

