/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.log;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.ce.ComputeEngineSide;

@ComputeEngineSide
public interface CeTaskMessages {
    public void add(Message var1);

    public void addAll(Collection<Message> var1);

    @Immutable
    public static class Message {
        private final String text;
        private final long timestamp;

        public Message(String text, long timestamp) {
            Preconditions.checkArgument((text != null && !text.isEmpty() ? 1 : 0) != 0, (Object)"Text can't be null nor empty");
            Preconditions.checkArgument((timestamp >= 0L ? 1 : 0) != 0, (Object)"Text can't be less than 0");
            this.text = text;
            this.timestamp = timestamp;
        }

        public String getText() {
            return this.text;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Message message1 = (Message)o;
            return this.timestamp == message1.timestamp && Objects.equals(this.text, message1.text);
        }

        public int hashCode() {
            return Objects.hash(this.text, this.timestamp);
        }

        public String toString() {
            return "Message{text='" + this.text + '\'' + ", timestamp=" + this.timestamp + '}';
        }
    }
}

