/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.css.plugin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.css.plugin.AnalysisWarningsWrapper;
import org.sonar.css.plugin.CssRules;
import org.sonar.css.plugin.ExternalProcessStreamConsumer;
import org.sonar.css.plugin.LinterCommandProvider;
import org.sonar.css.plugin.StylelintReport;
import org.sonar.css.plugin.bundle.BundleHandler;

public class CssRuleSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(CssRuleSensor.class);
    private static final int MIN_NODE_VERSION = 6;
    private static final String WARNING_PREFIX = "CSS files were not analyzed. ";
    private final BundleHandler bundleHandler;
    private final CssRules cssRules;
    private final LinterCommandProvider linterCommandProvider;
    @Nullable
    private final AnalysisWarningsWrapper analysisWarnings;
    private final ExternalProcessStreamConsumer externalProcessStreamConsumer = new ExternalProcessStreamConsumer();

    public CssRuleSensor(BundleHandler bundleHandler, CheckFactory checkFactory, LinterCommandProvider linterCommandProvider, @Nullable AnalysisWarningsWrapper analysisWarnings) {
        this.bundleHandler = bundleHandler;
        this.linterCommandProvider = linterCommandProvider;
        this.cssRules = new CssRules(checkFactory);
        this.analysisWarnings = analysisWarnings;
    }

    public CssRuleSensor(BundleHandler bundleHandler, CheckFactory checkFactory, LinterCommandProvider linterCommandProvider) {
        this(bundleHandler, checkFactory, linterCommandProvider, null);
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("css").name("SonarCSS Rules");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SensorContext context) {
        if (this.cssRules.isEmpty()) {
            LOG.warn("No rules are activated in CSS Quality Profile");
            return;
        }
        if (!this.checkCompatibleNodeVersion(context)) {
            return;
        }
        File deployDestination = context.fileSystem().workDir();
        this.bundleHandler.deployBundle(deployDestination);
        CharSequence[] commandParts = this.linterCommandProvider.commandParts(deployDestination, context);
        try {
            ProcessBuilder processBuilder = new ProcessBuilder((String[])commandParts);
            this.createLinterConfig(deployDestination);
            Process process = processBuilder.start();
            StringBuilder output = new StringBuilder();
            this.externalProcessStreamConsumer.consumeStream(process.getInputStream(), output::append);
            this.externalProcessStreamConsumer.consumeStream(process.getErrorStream(), arg_0 -> ((Logger)LOG).error(arg_0));
            if (this.isSuccessful(process)) {
                this.saveIssues(context, output.toString());
            }
        }
        catch (Exception e) {
            LOG.error("Failed to run external linting process " + String.join((CharSequence)" ", commandParts), (Throwable)e);
        }
        finally {
            this.externalProcessStreamConsumer.shutdownNow();
        }
    }

    private boolean isSuccessful(Process process) throws InterruptedException {
        boolean isSuccessful;
        int exitValue = process.waitFor();
        this.externalProcessStreamConsumer.await();
        boolean bl = isSuccessful = exitValue == 0 || exitValue == 2;
        if (!isSuccessful) {
            LOG.error("Analysis didn't terminate normally, please verify ERROR and WARN logs above. Exit code {}", (Object)exitValue);
        }
        return isSuccessful;
    }

    private boolean checkCompatibleNodeVersion(SensorContext context) {
        String version;
        String nodeExecutable = this.linterCommandProvider.nodeExecutable(context.config());
        LOG.debug("Checking node version");
        String messageSuffix = "No CSS files will be analyzed.";
        try {
            Process process = Runtime.getRuntime().exec(nodeExecutable + " -v");
            version = IOUtils.toString(process.getInputStream(), StandardCharsets.UTF_8).trim();
        }
        catch (Exception e) {
            LOG.error("Failed to get Node.js version. " + messageSuffix, (Throwable)e);
            if (this.analysisWarnings != null) {
                this.analysisWarnings.addUnique("CSS files were not analyzed. Node.js version could not be detected using command: " + nodeExecutable + " -v");
            }
            return false;
        }
        Pattern versionPattern = Pattern.compile("v?(\\d+)\\.\\d+\\.\\d+");
        Matcher versionMatcher = versionPattern.matcher(version);
        if (versionMatcher.matches()) {
            int major = Integer.parseInt(versionMatcher.group(1));
            if (major < 6) {
                String message = String.format("Only Node.js v%s or later is supported, got %s.", 6, version);
                LOG.error(message + ' ' + messageSuffix);
                if (this.analysisWarnings != null) {
                    this.analysisWarnings.addUnique(WARNING_PREFIX + message);
                }
                return false;
            }
        } else {
            String message = String.format("Failed to parse Node.js version, got '%s'.", version);
            LOG.error(message + ' ' + messageSuffix);
            if (this.analysisWarnings != null) {
                this.analysisWarnings.addUnique(WARNING_PREFIX + message);
            }
            return false;
        }
        LOG.debug(String.format("Using Node.js %s", version));
        return true;
    }

    private void createLinterConfig(File deployDestination) throws IOException {
        String configPath = this.linterCommandProvider.configPath(deployDestination);
        CssRules.StylelintConfig config = this.cssRules.getConfig();
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter((Type)((Object)CssRules.StylelintConfig.class), config);
        Gson gson = gsonBuilder.create();
        String configAsJson = gson.toJson(config);
        Files.write(Paths.get(configPath, new String[0]), Collections.singletonList(configAsJson), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private static String normalizeMessage(String message) {
        Pattern pattern = Pattern.compile("(.+)\\([a-z\\-]+\\)");
        Matcher matcher = pattern.matcher(message);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return message;
    }

    private void saveIssues(SensorContext context, String issuesAsJson) {
        StylelintReport.IssuesPerFile[] issues;
        try {
            issues = new Gson().fromJson(issuesAsJson, StylelintReport.IssuesPerFile[].class);
        }
        catch (JsonSyntaxException e) {
            throw new IllegalStateException("Failed to parse JSON result of external linting process execution: \n-------\n" + issuesAsJson + "\n-------", e);
        }
        FileSystem fileSystem = context.fileSystem();
        for (StylelintReport.IssuesPerFile issuesPerFile : issues) {
            InputFile inputFile = fileSystem.inputFile(fileSystem.predicates().hasAbsolutePath(issuesPerFile.source));
            if (inputFile == null) continue;
            for (StylelintReport.Issue issue : issuesPerFile.warnings) {
                this.saveIssue(context, inputFile, issue);
            }
        }
    }

    private void saveIssue(SensorContext context, InputFile inputFile, StylelintReport.Issue issue) {
        NewIssue sonarIssue = context.newIssue();
        RuleKey ruleKey = this.cssRules.getActiveSonarKey(issue.rule);
        if (ruleKey == null) {
            if ("CssSyntaxError".equals(issue.rule)) {
                LOG.error("Failed to parse " + inputFile.uri());
            } else {
                LOG.error("Unknown stylelint rule or rule not enabled: '" + issue.rule + "'");
            }
        } else {
            NewIssueLocation location = sonarIssue.newLocation().on((InputComponent)inputFile).at(inputFile.selectLine(issue.line)).message(CssRuleSensor.normalizeMessage(issue.text));
            sonarIssue.at(location).forRule(ruleKey).save();
        }
    }
}

