/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.css.plugin;

import java.io.IOException;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputFileFilter;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class MinifiedFilesFilter
implements InputFileFilter {
    private static final int AVERAGE_LINE_LENGTH_THRESHOLD = 200;
    private static final Logger LOG = Loggers.get(MinifiedFilesFilter.class);

    public boolean accept(InputFile file) {
        if (!"css".equals(file.language())) {
            return true;
        }
        try {
            boolean isMinified;
            boolean bl = isMinified = MinifiedFilesFilter.hasMinifiedFileName(file) || MinifiedFilesFilter.hasExcessiveAverageLineLength(file);
            if (isMinified) {
                LOG.debug("File [" + file.uri() + "] looks like a minified file and will not be analyzed");
            }
            return !isMinified;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read input file", e);
        }
    }

    private static boolean hasMinifiedFileName(InputFile file) {
        String fileName = file.filename();
        return fileName.endsWith("-min.css") || fileName.endsWith(".min.css");
    }

    private static boolean hasExcessiveAverageLineLength(InputFile file) throws IOException {
        int averageLineLength = file.contents().length() / file.lines();
        return averageLineLength > 200;
    }
}

