/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.css.plugin;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.css.plugin.CssRules;
import org.sonar.css.plugin.StylelintReport;
import org.sonarsource.analyzer.commons.ExternalReportProvider;
import org.sonarsource.analyzer.commons.ExternalRuleLoader;

public class StylelintReportSensor
implements Sensor {
    public static final String STYLELINT = "stylelint";
    private static final Logger LOG = Loggers.get(StylelintReportSensor.class);
    private static final String FILE_EXCEPTION_MESSAGE = "No issues information will be saved as the report file can't be read.";
    private final CssRules cssRules;
    private ExternalRuleLoader stylelintRuleLoader = StylelintReportSensor.getStylelintRuleLoader();

    public StylelintReportSensor(CheckFactory checkFactory) {
        this.cssRules = new CssRules(checkFactory);
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("css").onlyWhenConfiguration(conf -> conf.hasKey("sonar.css.stylelint.reportPaths")).name("Import of stylelint issues");
    }

    public void execute(SensorContext context) {
        List<File> reportFiles = ExternalReportProvider.getReportFiles(context, "sonar.css.stylelint.reportPaths");
        reportFiles.forEach(report -> this.importReport((File)report, context));
    }

    private void importReport(File report, SensorContext context) {
        LOG.info("Importing {}", (Object)report.getAbsoluteFile());
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(report), StandardCharsets.UTF_8);){
            StylelintReport.IssuesPerFile[] issues;
            for (StylelintReport.IssuesPerFile issuesPerFile : issues = new Gson().fromJson((Reader)inputStreamReader, StylelintReport.IssuesPerFile[].class)) {
                InputFile inputFile = StylelintReportSensor.getInputFile(context, issuesPerFile.source);
                if (inputFile == null) continue;
                for (StylelintReport.Issue issue : issuesPerFile.warnings) {
                    this.saveStylelintIssue(context, issue, inputFile);
                }
            }
        }
        catch (IOException e) {
            LOG.error(FILE_EXCEPTION_MESSAGE, (Throwable)e);
        }
        catch (JsonSyntaxException e) {
            LOG.error("Failed to parse json stylelint report", (Throwable)e);
        }
    }

    @Nullable
    private static InputFile getInputFile(SensorContext context, String fileName) {
        FilePredicates predicates = context.fileSystem().predicates();
        InputFile inputFile = context.fileSystem().inputFile(predicates.or(predicates.hasRelativePath(fileName), predicates.hasAbsolutePath(fileName)));
        if (inputFile == null) {
            LOG.warn("No input file found for {}. No stylelint issues will be imported on this file.", (Object)fileName);
            return null;
        }
        return inputFile;
    }

    private void saveStylelintIssue(SensorContext context, StylelintReport.Issue issue, InputFile inputFile) {
        String stylelintKey = issue.rule;
        RuleKey sonarKey = this.cssRules.getActiveSonarKey(stylelintKey);
        if (sonarKey != null) {
            String message = "Stylelint issue for rule '{}' is skipped because this rule is activated in your SonarQube profile for CSS (rule key in SQ {})";
            LOG.debug(message, (Object)stylelintKey, (Object)sonarKey.toString());
            return;
        }
        NewExternalIssue newExternalIssue = context.newExternalIssue();
        NewIssueLocation primaryLocation = newExternalIssue.newLocation().message(issue.text).on((InputComponent)inputFile).at(inputFile.selectLine(issue.line));
        newExternalIssue.at(primaryLocation).forRule(RuleKey.of((String)STYLELINT, (String)stylelintKey)).type(this.stylelintRuleLoader.ruleType(stylelintKey)).severity(this.stylelintRuleLoader.ruleSeverity(stylelintKey)).remediationEffortMinutes(this.stylelintRuleLoader.ruleConstantDebtMinutes(stylelintKey)).save();
    }

    public static ExternalRuleLoader getStylelintRuleLoader() {
        return new ExternalRuleLoader(STYLELINT, STYLELINT, "org/sonar/l10n/css/rules/stylelint/rules.json", "css");
    }
}

