/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.alm;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.System2;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.Dao;
import org.sonar.db.DbSession;
import org.sonar.db.alm.ALM;
import org.sonar.db.alm.AlmAppInstallDto;
import org.sonar.db.alm.AlmAppInstallMapper;
import org.sonar.db.organization.OrganizationDto;

public class AlmAppInstallDao
implements Dao {
    private final System2 system2;
    private final UuidFactory uuidFactory;

    public AlmAppInstallDao(System2 system2, UuidFactory uuidFactory) {
        this.system2 = system2;
        this.uuidFactory = uuidFactory;
    }

    public Optional<AlmAppInstallDto> selectByUuid(DbSession dbSession, String uuid) {
        AlmAppInstallMapper mapper = AlmAppInstallDao.getMapper(dbSession);
        return Optional.ofNullable(mapper.selectByUuid(uuid));
    }

    public Optional<AlmAppInstallDto> selectByOrganizationAlmId(DbSession dbSession, ALM alm, String organizationAlmId) {
        AlmAppInstallDao.checkAlm(alm);
        AlmAppInstallDao.checkOrganizationAlmId(organizationAlmId);
        AlmAppInstallMapper mapper = AlmAppInstallDao.getMapper(dbSession);
        return Optional.ofNullable(mapper.selectByOrganizationAlmId(alm.getId(), organizationAlmId));
    }

    public Optional<AlmAppInstallDto> selectByInstallationId(DbSession dbSession, ALM alm, String installationId) {
        AlmAppInstallMapper mapper = AlmAppInstallDao.getMapper(dbSession);
        return Optional.ofNullable(mapper.selectByInstallationId(alm.getId(), installationId));
    }

    public Optional<AlmAppInstallDto> selectByOrganization(DbSession dbSession, ALM alm, OrganizationDto organization) {
        AlmAppInstallMapper mapper = AlmAppInstallDao.getMapper(dbSession);
        return Optional.ofNullable(mapper.selectByOrganizationUuid(alm.getId(), organization.getUuid()));
    }

    public List<AlmAppInstallDto> selectUnboundByUserExternalId(DbSession dbSession, String userExternalId) {
        return AlmAppInstallDao.getMapper(dbSession).selectUnboundByUserExternalId(userExternalId);
    }

    public void insertOrUpdate(DbSession dbSession, ALM alm, String organizationAlmId, @Nullable Boolean isOwnerUser, String installId, @Nullable String userExternalId) {
        AlmAppInstallDao.checkAlm(alm);
        AlmAppInstallDao.checkOrganizationAlmId(organizationAlmId);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)installId), (Object)"installId can't be null nor empty");
        AlmAppInstallMapper mapper = AlmAppInstallDao.getMapper(dbSession);
        long now = this.system2.now();
        if (mapper.update(alm.getId(), organizationAlmId, isOwnerUser, installId, userExternalId, now) == 0) {
            mapper.insert(this.uuidFactory.create(), alm.getId(), organizationAlmId, isOwnerUser, installId, userExternalId, now);
        }
    }

    public void delete(DbSession dbSession, ALM alm, String organizationAlmId) {
        AlmAppInstallDao.checkAlm(alm);
        AlmAppInstallDao.checkOrganizationAlmId(organizationAlmId);
        AlmAppInstallMapper mapper = AlmAppInstallDao.getMapper(dbSession);
        mapper.delete(alm.getId(), organizationAlmId);
    }

    private static void checkAlm(@Nullable ALM alm) {
        Objects.requireNonNull(alm, "alm can't be null");
    }

    private static void checkOrganizationAlmId(@Nullable String organizationAlmId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)organizationAlmId), (Object)"organizationAlmId can't be null nor empty");
    }

    private static AlmAppInstallMapper getMapper(DbSession dbSession) {
        return (AlmAppInstallMapper)dbSession.getMapper(AlmAppInstallMapper.class);
    }
}

