/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.alm;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.System2;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.alm.ALM;
import org.sonar.db.alm.ProjectAlmBindingDto;
import org.sonar.db.alm.ProjectAlmBindingMapper;

public class ProjectAlmBindingDao
implements Dao {
    private final System2 system2;
    private final UuidFactory uuidFactory;

    public ProjectAlmBindingDao(System2 system2, UuidFactory uuidFactory) {
        this.system2 = system2;
        this.uuidFactory = uuidFactory;
    }

    public void insertOrUpdate(DbSession dbSession, ALM alm, String repoId, String projectUuid, @Nullable String githubSlug, String url) {
        ProjectAlmBindingDao.checkAlm(alm);
        ProjectAlmBindingDao.checkRepoId(repoId);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)projectUuid), (Object)"projectUuid can't be null nor empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)url), (Object)"url can't be null nor empty");
        ProjectAlmBindingMapper mapper = ProjectAlmBindingDao.getMapper(dbSession);
        long now = this.system2.now();
        if (mapper.update(alm.getId(), repoId, projectUuid, githubSlug, url, now) == 0) {
            mapper.insert(this.uuidFactory.create(), alm.getId(), repoId, projectUuid, githubSlug, url, now);
        }
    }

    public Optional<ProjectAlmBindingDto> selectByProjectUuid(DbSession session, String projectUuid) {
        return Optional.ofNullable(ProjectAlmBindingDao.getMapper(session).selectByProjectUuid(projectUuid));
    }

    public List<ProjectAlmBindingDto> selectByRepoIds(DbSession session, ALM alm, Collection<String> repoIds) {
        return DatabaseUtils.executeLargeInputs(repoIds, partitionedIds -> ProjectAlmBindingDao.getMapper(session).selectByRepoIds(alm.getId(), (List<String>)partitionedIds));
    }

    public Optional<ProjectAlmBindingDto> selectByRepoId(DbSession session, ALM alm, String repoId) {
        return Optional.ofNullable(ProjectAlmBindingDao.getMapper(session).selectByRepoId(alm.getId(), repoId));
    }

    public Optional<String> findProjectKey(DbSession dbSession, ALM alm, String repoId) {
        ProjectAlmBindingDao.checkAlm(alm);
        ProjectAlmBindingDao.checkRepoId(repoId);
        ProjectAlmBindingMapper mapper = ProjectAlmBindingDao.getMapper(dbSession);
        return Optional.ofNullable(mapper.selectProjectKey(alm.getId(), repoId));
    }

    private static void checkAlm(@Nullable ALM alm) {
        Objects.requireNonNull(alm, "alm can't be null");
    }

    private static void checkRepoId(@Nullable String repoId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)repoId), (Object)"repoId can't be null nor empty");
    }

    private static ProjectAlmBindingMapper getMapper(DbSession dbSession) {
        return (ProjectAlmBindingMapper)dbSession.getMapper(ProjectAlmBindingMapper.class);
    }
}

