/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.component;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.api.utils.System2;
import org.sonar.db.Dao;
import org.sonar.db.DbSession;
import org.sonar.db.component.AnalysisPropertiesMapper;
import org.sonar.db.component.AnalysisPropertyDto;

public class AnalysisPropertiesDao
implements Dao {
    private static final int VARCHAR_MAXSIZE = 4000;
    private final System2 system2;

    public AnalysisPropertiesDao(System2 system2) {
        this.system2 = system2;
    }

    public List<AnalysisPropertyDto> selectBySnapshotUuid(DbSession session, String snapshotUuid) {
        Objects.requireNonNull(snapshotUuid);
        return AnalysisPropertiesDao.getMapper(session).selectBySnapshotUuid(snapshotUuid);
    }

    public void insert(DbSession session, List<AnalysisPropertyDto> analysisPropertyDto) {
        analysisPropertyDto.forEach(a -> this.insert(session, (AnalysisPropertyDto)a));
    }

    public void insert(DbSession session, AnalysisPropertyDto analysisPropertyDto) {
        Objects.requireNonNull(analysisPropertyDto.getUuid(), "uuid cannot be null");
        Objects.requireNonNull(analysisPropertyDto.getKey(), "key cannot be null");
        Objects.requireNonNull(analysisPropertyDto.getSnapshotUuid(), "snapshot uuid cannot be null");
        Objects.requireNonNull(analysisPropertyDto.getValue(), "value cannot be null");
        String value = analysisPropertyDto.getValue();
        long now = this.system2.now();
        if (AnalysisPropertiesDao.isEmpty(value)) {
            AnalysisPropertiesDao.getMapper(session).insertAsEmpty(analysisPropertyDto, now);
        } else if (AnalysisPropertiesDao.mustBeStoredInClob(value)) {
            AnalysisPropertiesDao.getMapper(session).insertAsClob(analysisPropertyDto, now);
        } else {
            AnalysisPropertiesDao.getMapper(session).insertAsText(analysisPropertyDto, now);
        }
    }

    private static boolean mustBeStoredInClob(String value) {
        return value.length() > 4000;
    }

    private static boolean isEmpty(@Nullable String str) {
        return str == null || str.isEmpty();
    }

    private static AnalysisPropertiesMapper getMapper(DbSession session) {
        return (AnalysisPropertiesMapper)session.getMapper(AnalysisPropertiesMapper.class);
    }
}

