/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.component;

import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.Dao;
import org.sonar.db.DaoUtils;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.RowNotFoundException;
import org.sonar.db.WildcardPosition;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentMapper;
import org.sonar.db.component.ComponentQuery;
import org.sonar.db.component.ComponentTreeQuery;
import org.sonar.db.component.ComponentUpdateDto;
import org.sonar.db.component.ComponentWithModuleUuidDto;
import org.sonar.db.component.FileMoveRowDto;
import org.sonar.db.component.FilePathWithHashDto;
import org.sonar.db.component.KeyWithUuidDto;
import org.sonar.db.component.ProjectNclocDistributionDto;
import org.sonar.db.component.UuidWithProjectUuidDto;

public class ComponentDao
implements Dao {
    private static List<ComponentDto> selectByQueryImpl(DbSession session, @Nullable String organizationUuid, ComponentQuery query, int offset, int limit) {
        if (query.hasEmptySetOfComponents()) {
            return Collections.emptyList();
        }
        ComponentDao.checkThatNotTooManyComponents(query);
        return ComponentDao.mapper(session).selectByQuery(organizationUuid, query, new RowBounds(offset, limit));
    }

    private static int countByQueryImpl(DbSession session, @Nullable String organizationUuid, ComponentQuery query) {
        if (query.hasEmptySetOfComponents()) {
            return 0;
        }
        ComponentDao.checkThatNotTooManyComponents(query);
        return ComponentDao.mapper(session).countByQuery(organizationUuid, query);
    }

    @CheckForNull
    private static String buildUpperLikeSql(@Nullable String textQuery) {
        if (StringUtils.isBlank((String)textQuery)) {
            return null;
        }
        return DaoUtils.buildLikeValue(textQuery.toUpperCase(Locale.ENGLISH), WildcardPosition.BEFORE_AND_AFTER);
    }

    private static ComponentMapper mapper(DbSession session) {
        return (ComponentMapper)session.getMapper(ComponentMapper.class);
    }

    public Optional<ComponentDto> selectById(DbSession session, long id) {
        return Optional.ofNullable(ComponentDao.mapper(session).selectById(id));
    }

    public Optional<ComponentDto> selectByUuid(DbSession session, String uuid) {
        return Optional.ofNullable(ComponentDao.mapper(session).selectByUuid(uuid));
    }

    public ComponentDto selectOrFailByUuid(DbSession session, String uuid) {
        Optional<ComponentDto> componentDto = this.selectByUuid(session, uuid);
        if (!componentDto.isPresent()) {
            throw new RowNotFoundException(String.format("Component with uuid '%s' not found", uuid));
        }
        return componentDto.get();
    }

    public List<ComponentDto> selectByQuery(DbSession session, ComponentQuery query, int offset, int limit) {
        return ComponentDao.selectByQueryImpl(session, null, query, offset, limit);
    }

    public List<ComponentDto> selectByQuery(DbSession dbSession, String organizationUuid, ComponentQuery query, int offset, int limit) {
        Objects.requireNonNull(organizationUuid, "organizationUuid can't be null");
        return ComponentDao.selectByQueryImpl(dbSession, organizationUuid, query, offset, limit);
    }

    public int countByQuery(DbSession session, ComponentQuery query) {
        return ComponentDao.countByQueryImpl(session, null, query);
    }

    public int countByQuery(DbSession session, String organizationUuid, ComponentQuery query) {
        Objects.requireNonNull(organizationUuid, "organizationUuid can't be null");
        return ComponentDao.countByQueryImpl(session, organizationUuid, query);
    }

    public List<ComponentDto> selectSubProjectsByComponentUuids(DbSession session, Collection<String> uuids) {
        if (uuids.isEmpty()) {
            return Collections.emptyList();
        }
        return ComponentDao.mapper(session).selectSubProjectsByComponentUuids(uuids);
    }

    public List<ComponentDto> selectDescendantModules(DbSession session, String rootComponentUuid) {
        return ComponentDao.mapper(session).selectDescendantModules(rootComponentUuid, "PRJ", false);
    }

    public List<ComponentDto> selectEnabledDescendantModules(DbSession session, String rootComponentUuid) {
        return ComponentDao.mapper(session).selectDescendantModules(rootComponentUuid, "PRJ", true);
    }

    public List<FilePathWithHashDto> selectEnabledDescendantFiles(DbSession session, String rootComponentUuid) {
        return ComponentDao.mapper(session).selectDescendantFiles(rootComponentUuid, "FIL", true);
    }

    public List<FilePathWithHashDto> selectEnabledFilesFromProject(DbSession session, String rootComponentUuid) {
        return ComponentDao.mapper(session).selectEnabledFilesFromProject(rootComponentUuid);
    }

    public List<ComponentDto> selectByIds(DbSession session, Collection<Long> ids) {
        return DatabaseUtils.executeLargeInputs(ids, ComponentDao.mapper(session)::selectByIds);
    }

    public List<ComponentDto> selectByUuids(DbSession session, Collection<String> uuids) {
        return DatabaseUtils.executeLargeInputs(uuids, ComponentDao.mapper(session)::selectByUuids);
    }

    public List<String> selectExistingUuids(DbSession session, Collection<String> uuids) {
        return DatabaseUtils.executeLargeInputs(uuids, ComponentDao.mapper(session)::selectExistingUuids);
    }

    public List<ComponentDto> selectAllComponentsFromProjectKey(DbSession session, String projectKey) {
        return ComponentDao.mapper(session).selectComponentsFromProjectKeyAndScope(projectKey, null, false);
    }

    public List<KeyWithUuidDto> selectUuidsByKeyFromProjectKey(DbSession session, String projectKey) {
        return ComponentDao.mapper(session).selectUuidsByKeyFromProjectKey(projectKey);
    }

    public List<ComponentDto> selectProjectAndModulesFromProjectKey(DbSession session, String projectKey, boolean excludeDisabled) {
        return ComponentDao.mapper(session).selectComponentsFromProjectKeyAndScope(projectKey, "PRJ", excludeDisabled);
    }

    public int countEnabledModulesByProjectUuid(DbSession session, String projectUuid) {
        return ComponentDao.mapper(session).countEnabledModulesByProjectUuid(projectUuid);
    }

    public List<ComponentDto> selectEnabledModulesFromProjectKey(DbSession session, String projectKey) {
        return this.selectProjectAndModulesFromProjectKey(session, projectKey, true);
    }

    public List<ComponentDto> selectByKeys(DbSession session, Collection<String> keys) {
        return DatabaseUtils.executeLargeInputs(keys, ComponentDao.mapper(session)::selectByKeys);
    }

    public List<ComponentDto> selectByKeysAndBranch(DbSession session, Collection<String> keys, String branch) {
        List dbKeys = (List)keys.stream().map(k -> ComponentDto.generateBranchKey(k, branch)).collect(MoreCollectors.toList());
        List allKeys = (List)Stream.of(keys, dbKeys).flatMap(Collection::stream).collect(MoreCollectors.toList());
        return DatabaseUtils.executeLargeInputs((Collection)allKeys, subKeys -> ComponentDao.mapper(session).selectByKeysAndBranch((Collection<String>)subKeys, branch));
    }

    public List<ComponentDto> selectByKeysAndBranches(DbSession session, Map<String, String> branchesByKey) {
        Set dbKeys = (Set)branchesByKey.entrySet().stream().map(entry -> ComponentDto.generateBranchKey((String)entry.getKey(), (String)entry.getValue())).collect(MoreCollectors.toSet());
        return this.selectByDbKeys(session, dbKeys);
    }

    public List<ComponentDto> selectByDbKeys(DbSession session, Set<String> dbKeys) {
        return DatabaseUtils.executeLargeInputs(dbKeys, subKeys -> ComponentDao.mapper(session).selectByDbKeys((Collection<String>)subKeys));
    }

    public List<ComponentDto> selectByKeysAndPullRequest(DbSession session, Collection<String> keys, String pullRequestId) {
        List dbKeys = (List)keys.stream().map(k -> ComponentDto.generatePullRequestKey(k, pullRequestId)).collect(MoreCollectors.toList());
        List allKeys = (List)Stream.of(keys, dbKeys).flatMap(Collection::stream).collect(MoreCollectors.toList());
        return DatabaseUtils.executeLargeInputs((Collection)allKeys, subKeys -> ComponentDao.mapper(session).selectByKeysAndBranch((Collection<String>)subKeys, pullRequestId));
    }

    public List<ComponentDto> selectComponentsHavingSameKeyOrderedById(DbSession session, String key) {
        return ComponentDao.mapper(session).selectComponentsHavingSameKeyOrderedById(key);
    }

    public List<ComponentDto> selectAncestors(DbSession dbSession, ComponentDto component) {
        if (component.isRoot()) {
            return Collections.emptyList();
        }
        List<String> ancestorUuids = component.getUuidPathAsList();
        List<ComponentDto> ancestors = this.selectByUuids(dbSession, ancestorUuids);
        return Ordering.explicit(ancestorUuids).onResultOf(ComponentDto::uuid).immutableSortedCopy(ancestors);
    }

    public List<ComponentDto> selectDescendants(DbSession dbSession, ComponentTreeQuery query) {
        Optional<ComponentDto> componentOpt = this.selectByUuid(dbSession, query.getBaseUuid());
        if (!componentOpt.isPresent()) {
            return Collections.emptyList();
        }
        ComponentDto component = componentOpt.get();
        return ComponentDao.mapper(dbSession).selectDescendants(query, componentOpt.get().uuid(), query.getUuidPath(component));
    }

    public ComponentDto selectOrFailByKey(DbSession session, String key) {
        Optional<ComponentDto> component = this.selectByKey(session, key);
        if (!component.isPresent()) {
            throw new RowNotFoundException(String.format("Component key '%s' not found", key));
        }
        return component.get();
    }

    public Optional<ComponentDto> selectByKey(DbSession session, String key) {
        return Optional.ofNullable(ComponentDao.mapper(session).selectByKey(key));
    }

    public Optional<ComponentDto> selectByKeyAndBranch(DbSession session, String key, String branch) {
        return Optional.ofNullable(ComponentDao.mapper(session).selectBranchByKeyAndBranchKey(key, ComponentDto.generateBranchKey(key, branch), branch));
    }

    public Optional<ComponentDto> selectByKeyAndPullRequest(DbSession session, String key, String pullRequestId) {
        return Optional.ofNullable(ComponentDao.mapper(session).selectPrByKeyAndBranchKey(key, ComponentDto.generatePullRequestKey(key, pullRequestId), pullRequestId));
    }

    public List<UuidWithProjectUuidDto> selectAllViewsAndSubViews(DbSession session) {
        return ComponentDao.mapper(session).selectUuidsForQualifiers("APP", "VW", "SVW");
    }

    public Set<String> selectViewKeysWithEnabledCopyOfProject(DbSession session, Set<String> projectUuids) {
        return DatabaseUtils.executeLargeInputsIntoSet(projectUuids, partition -> ComponentDao.mapper(session).selectViewKeysWithEnabledCopyOfProject((Collection<String>)partition), i -> i);
    }

    public List<String> selectProjectsFromView(DbSession session, String viewUuid, String projectViewUuid) {
        return ComponentDao.mapper(session).selectProjectsFromView("%." + viewUuid + ".%", projectViewUuid);
    }

    public List<ComponentDto> selectProjects(DbSession session) {
        return ComponentDao.mapper(session).selectProjects();
    }

    public List<ComponentDto> selectProjectsByOrganization(DbSession dbSession, String organizationUuid) {
        return ComponentDao.mapper(dbSession).selectProjectsByOrganization(organizationUuid);
    }

    public List<ComponentDto> selectGhostProjects(DbSession session, String organizationUuid, @Nullable String query, int offset, int limit) {
        return ComponentDao.mapper(session).selectGhostProjects(organizationUuid, ComponentDao.buildUpperLikeSql(query), new RowBounds(offset, limit));
    }

    public long countGhostProjects(DbSession session, String organizationUuid, @Nullable String query) {
        return ComponentDao.mapper(session).countGhostProjects(organizationUuid, ComponentDao.buildUpperLikeSql(query));
    }

    public void scrollForIndexing(DbSession session, @Nullable String projectUuid, ResultHandler<ComponentDto> handler) {
        ComponentDao.mapper(session).scrollForIndexing(projectUuid, handler);
    }

    public List<ComponentDto> selectByProjectUuid(String projectUuid, DbSession dbSession) {
        return ComponentDao.mapper(dbSession).selectByProjectUuid(projectUuid);
    }

    public Set<ComponentDto> selectComponentsByQualifiers(DbSession dbSession, Set<String> qualifiers) {
        Preconditions.checkArgument((!qualifiers.isEmpty() ? 1 : 0) != 0, (Object)"Qualifiers cannot be empty");
        return new HashSet<ComponentDto>(ComponentDao.mapper(dbSession).selectComponentsByQualifiers(qualifiers));
    }

    public List<ComponentWithModuleUuidDto> selectEnabledComponentsWithModuleUuidFromProjectKey(DbSession dbSession, String projectKey) {
        return ComponentDao.mapper(dbSession).selectEnabledComponentsWithModuleUuidFromProjectKey(projectKey);
    }

    public List<ComponentDto> selectProjectsByNameQuery(DbSession dbSession, @Nullable String nameQuery, boolean includeModules) {
        String nameQueryForSql = nameQuery == null ? null : DaoUtils.buildLikeValue(nameQuery, WildcardPosition.BEFORE_AND_AFTER).toUpperCase(Locale.ENGLISH);
        return ComponentDao.mapper(dbSession).selectProjectsByNameQuery(nameQueryForSql, includeModules);
    }

    public List<KeyWithUuidDto> selectComponentKeysHavingIssuesToMerge(DbSession dbSession, String mergeBranchUuid) {
        return ComponentDao.mapper(dbSession).selectComponentKeysHavingIssuesToMerge(mergeBranchUuid);
    }

    public void scrollAllFilesForFileMove(DbSession session, String projectUuid, ResultHandler<FileMoveRowDto> handler) {
        ComponentDao.mapper(session).scrollAllFilesForFileMove(projectUuid, handler);
    }

    public void insert(DbSession session, ComponentDto item) {
        ComponentDao.mapper(session).insert(item);
    }

    public void insert(DbSession session, Collection<ComponentDto> items) {
        this.insert(session, items.stream());
    }

    private void insert(DbSession session, Stream<ComponentDto> items) {
        items.forEach(item -> this.insert(session, (ComponentDto)item));
    }

    public void insert(DbSession session, ComponentDto item, ComponentDto ... others) {
        this.insert(session, Stream.concat(Stream.of(item), Arrays.stream(others)));
    }

    public void update(DbSession session, ComponentUpdateDto component) {
        ComponentDao.mapper(session).update(component);
    }

    public void updateTags(DbSession session, ComponentDto component) {
        ComponentDao.mapper(session).updateTags(component);
    }

    public void updateBEnabledToFalse(DbSession session, Collection<String> uuids) {
        DatabaseUtils.executeLargeUpdates(uuids, ComponentDao.mapper(session)::updateBEnabledToFalse);
    }

    public void applyBChangesForRootComponentUuid(DbSession session, String projectUuid) {
        ComponentDao.mapper(session).applyBChangesForRootComponentUuid(projectUuid);
    }

    public void resetBChangedForRootComponentUuid(DbSession session, String projectUuid) {
        ComponentDao.mapper(session).resetBChangedForRootComponentUuid(projectUuid);
    }

    public void setPrivateForRootComponentUuid(DbSession session, String projectUuid, boolean isPrivate) {
        ComponentDao.mapper(session).setPrivateForRootComponentUuid(projectUuid, isPrivate);
    }

    public void delete(DbSession session, long componentId) {
        ComponentDao.mapper(session).delete(componentId);
    }

    private static void checkThatNotTooManyComponents(ComponentQuery query) {
        DatabaseUtils.checkThatNotTooManyConditions(query.getComponentIds(), (String)"Too many component ids in query");
        DatabaseUtils.checkThatNotTooManyConditions(query.getComponentKeys(), (String)"Too many component keys in query");
        DatabaseUtils.checkThatNotTooManyConditions(query.getComponentUuids(), (String)"Too many component UUIDs in query");
    }

    public List<ProjectNclocDistributionDto> selectPrivateProjectsWithNcloc(DbSession dbSession, String organizationUuid) {
        return ComponentDao.mapper(dbSession).selectPrivateProjectsWithNcloc(organizationUuid);
    }

    public Optional<ComponentDto> selectByAlmIdAndAlmRepositoryId(DbSession dbSession, String almId, String almRepositoryId) {
        return Optional.ofNullable(ComponentDao.mapper(dbSession).selectByAlmIdAndAlmRepositoryId(almId, almRepositoryId));
    }
}

