/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.component;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.db.DaoUtils;
import org.sonar.db.WildcardPosition;

public class ComponentQuery {
    private final String nameOrKeyQuery;
    private final boolean partialMatchOnKey;
    private final String[] qualifiers;
    private final Boolean isPrivate;
    private final Set<Long> componentIds;
    private final Set<String> componentUuids;
    private final Set<String> componentKeys;
    private final Long analyzedBefore;
    private final Long anyBranchAnalyzedBefore;
    private final Long anyBranchAnalyzedAfter;
    private final Date createdAfter;
    private final boolean onProvisionedOnly;

    private ComponentQuery(Builder builder) {
        this.nameOrKeyQuery = builder.nameOrKeyQuery;
        this.partialMatchOnKey = builder.partialMatchOnKey == null ? false : builder.partialMatchOnKey;
        this.qualifiers = builder.qualifiers;
        this.componentIds = builder.componentIds;
        this.componentUuids = builder.componentUuids;
        this.componentKeys = builder.componentKeys;
        this.isPrivate = builder.isPrivate;
        this.analyzedBefore = builder.analyzedBefore;
        this.anyBranchAnalyzedBefore = builder.anyBranchAnalyzedBefore;
        this.anyBranchAnalyzedAfter = builder.anyBranchAnalyzedAfter;
        this.createdAfter = builder.createdAfter;
        this.onProvisionedOnly = builder.onProvisionedOnly;
    }

    public String[] getQualifiers() {
        return this.qualifiers;
    }

    @CheckForNull
    public String getNameOrKeyQuery() {
        return this.nameOrKeyQuery;
    }

    @CheckForNull
    public String getNameOrKeyUpperLikeQuery() {
        return DaoUtils.buildLikeValue(this.nameOrKeyQuery, WildcardPosition.BEFORE_AND_AFTER).toUpperCase(Locale.ENGLISH);
    }

    public boolean isPartialMatchOnKey() {
        return this.partialMatchOnKey;
    }

    @CheckForNull
    public Set<Long> getComponentIds() {
        return this.componentIds;
    }

    @CheckForNull
    public Set<String> getComponentUuids() {
        return this.componentUuids;
    }

    @CheckForNull
    public Set<String> getComponentKeys() {
        return this.componentKeys;
    }

    @CheckForNull
    public Boolean getPrivate() {
        return this.isPrivate;
    }

    @CheckForNull
    public Long getAnalyzedBefore() {
        return this.analyzedBefore;
    }

    @CheckForNull
    public Long getAnyBranchAnalyzedBefore() {
        return this.anyBranchAnalyzedBefore;
    }

    @CheckForNull
    public Long getAnyBranchAnalyzedAfter() {
        return this.anyBranchAnalyzedAfter;
    }

    @CheckForNull
    public Date getCreatedAfter() {
        return this.createdAfter;
    }

    public boolean isOnProvisionedOnly() {
        return this.onProvisionedOnly;
    }

    boolean hasEmptySetOfComponents() {
        return Stream.of(this.componentIds, this.componentKeys, this.componentUuids).anyMatch(list -> list != null && list.isEmpty());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String nameOrKeyQuery;
        private Boolean partialMatchOnKey;
        private String[] qualifiers;
        private Boolean isPrivate;
        private Set<Long> componentIds;
        private Set<String> componentUuids;
        private Set<String> componentKeys;
        private Long analyzedBefore;
        private Long anyBranchAnalyzedBefore;
        private Long anyBranchAnalyzedAfter;
        private Date createdAfter;
        private boolean onProvisionedOnly = false;

        public Builder setNameOrKeyQuery(@Nullable String nameOrKeyQuery) {
            this.nameOrKeyQuery = nameOrKeyQuery;
            return this;
        }

        public Builder setPartialMatchOnKey(@Nullable Boolean partialMatchOnKey) {
            this.partialMatchOnKey = partialMatchOnKey;
            return this;
        }

        public Builder setQualifiers(String ... qualifiers) {
            this.qualifiers = qualifiers;
            return this;
        }

        public Builder setComponentIds(@Nullable Set<Long> componentIds) {
            this.componentIds = componentIds;
            return this;
        }

        public Builder setComponentUuids(@Nullable Set<String> componentUuids) {
            this.componentUuids = componentUuids;
            return this;
        }

        public Builder setComponentKeys(@Nullable Set<String> componentKeys) {
            this.componentKeys = componentKeys;
            return this;
        }

        public Builder setPrivate(@Nullable Boolean isPrivate) {
            this.isPrivate = isPrivate;
            return this;
        }

        public Builder setAnalyzedBefore(@Nullable Long l) {
            this.analyzedBefore = l;
            return this;
        }

        public Builder setAnyBranchAnalyzedBefore(@Nullable Long l) {
            this.anyBranchAnalyzedBefore = l;
            return this;
        }

        public Builder setAnyBranchAnalyzedAfter(@Nullable Long l) {
            this.anyBranchAnalyzedAfter = l;
            return this;
        }

        public Builder setCreatedAfter(@Nullable Date l) {
            this.createdAfter = l;
            return this;
        }

        public Builder setOnProvisionedOnly(boolean onProvisionedOnly) {
            this.onProvisionedOnly = onProvisionedOnly;
            return this;
        }

        public ComponentQuery build() {
            Preconditions.checkArgument((this.qualifiers != null && this.qualifiers.length > 0 ? 1 : 0) != 0, (Object)"At least one qualifier must be provided");
            Preconditions.checkArgument((this.nameOrKeyQuery != null || this.partialMatchOnKey == null ? 1 : 0) != 0, (Object)"A query must be provided if a partial match on key is specified.");
            return new ComponentQuery(this);
        }
    }
}

