/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.component;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.Nullable;

public class ComponentValidator {
    public static final int MAX_COMPONENT_NAME_LENGTH = 500;
    public static final int MAX_COMPONENT_DESCRIPTION_LENGTH = 2000;
    private static final int MAX_COMPONENT_TAGS_LENGTH = 500;
    private static final int MAX_COMPONENT_QUALIFIER_LENGTH = 10;

    private ComponentValidator() {
    }

    public static String checkComponentName(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Component name can't be empty");
        Preconditions.checkArgument((name.length() <= 500 ? 1 : 0) != 0, (String)"Component name length (%s) is longer than the maximum authorized (%s). '%s' was provided.", (Object[])new Object[]{name.length(), 500, name});
        return name;
    }

    public static String checkComponentLongName(@Nullable String value) {
        if (value == null) {
            return null;
        }
        Preconditions.checkArgument((value.length() <= 500 ? 1 : 0) != 0, (String)"Component name length (%s) is longer than the maximum authorized (%s). '%s' was provided.", (Object[])new Object[]{value.length(), 500, value});
        return value;
    }

    public static String checkDescription(@Nullable String value) {
        if (value == null) {
            return null;
        }
        Preconditions.checkArgument((value.length() <= 500 ? 1 : 0) != 0, (String)"Component description length (%s) is longer than the maximum authorized (%s). '%s' was provided.", (Object[])new Object[]{value.length(), 2000, value});
        return value;
    }

    public static String checkTags(@Nullable String value) {
        if (value == null) {
            return null;
        }
        Preconditions.checkArgument((value.length() <= 500 ? 1 : 0) != 0, (String)"Component tags length (%s) is longer than the maximum authorized (%s). '%s' was provided.", (Object[])new Object[]{value.length(), 500, value});
        return value;
    }

    public static String checkComponentKey(String key) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"Component key can't be empty");
        Preconditions.checkArgument((key.length() <= 400 ? 1 : 0) != 0, (String)"Component key length (%s) is longer than the maximum authorized (%s). '%s' was provided.", (Object[])new Object[]{key.length(), 400, key});
        return key;
    }

    public static String checkComponentQualifier(String qualifier) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)qualifier) ? 1 : 0) != 0, (Object)"Component qualifier can't be empty");
        Preconditions.checkArgument((qualifier.length() <= 10 ? 1 : 0) != 0, (String)"Component qualifier length (%s) is longer than the maximum authorized (%s). '%s' was provided.", (Object[])new Object[]{qualifier.length(), 10, qualifier});
        return qualifier;
    }
}

