/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.component;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.ibatis.session.RowBounds;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.component.SnapshotMapper;
import org.sonar.db.component.SnapshotQuery;
import org.sonar.db.component.ViewsSnapshotDto;

public class SnapshotDao
implements Dao {
    public static boolean isLast(SnapshotDto snapshotTested, @Nullable SnapshotDto previousLastSnapshot) {
        return previousLastSnapshot == null || previousLastSnapshot.getCreatedAt() < snapshotTested.getCreatedAt();
    }

    public Optional<SnapshotDto> selectByUuid(DbSession dbSession, String analysisUuid) {
        List<SnapshotDto> dtos = SnapshotDao.mapper(dbSession).selectByUuids(Collections.singletonList(analysisUuid));
        if (dtos.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(dtos.iterator().next());
    }

    public List<SnapshotDto> selectByUuids(DbSession dbSession, Collection<String> analysisUuids) {
        return DatabaseUtils.executeLargeInputs(analysisUuids, SnapshotDao.mapper(dbSession)::selectByUuids);
    }

    public Optional<SnapshotDto> selectLastAnalysisByComponentUuid(DbSession session, String componentUuid) {
        return Optional.ofNullable(SnapshotDao.mapper(session).selectLastSnapshotByComponentUuid(componentUuid));
    }

    public Optional<SnapshotDto> selectLastAnalysisByRootComponentUuid(DbSession session, String componentUuid) {
        return Optional.ofNullable(SnapshotDao.mapper(session).selectLastSnapshotByRootComponentUuid(componentUuid));
    }

    public List<SnapshotDto> selectLastAnalysesByRootComponentUuids(DbSession dbSession, Collection<String> componentUuids) {
        return DatabaseUtils.executeLargeInputs(componentUuids, SnapshotDao.mapper(dbSession)::selectLastSnapshotsByRootComponentUuids);
    }

    public List<SnapshotDto> selectAnalysesByQuery(DbSession session, SnapshotQuery query) {
        return SnapshotDao.mapper(session).selectSnapshotsByQuery(query);
    }

    @CheckForNull
    public SnapshotDto selectAnalysisByQuery(DbSession session, SnapshotQuery query) {
        List<SnapshotDto> dtos = SnapshotDao.mapper(session).selectSnapshotsByQuery(query);
        if (dtos.isEmpty()) {
            return null;
        }
        Preconditions.checkState((dtos.size() == 1 ? 1 : 0) != 0, (String)"Expected one analysis to be returned, got %s", (Object[])new Object[]{dtos.size()});
        return dtos.get(0);
    }

    public Optional<SnapshotDto> selectOldestSnapshot(DbSession session, String componentUuid) {
        return SnapshotDao.mapper(session).selectOldestSnapshots(componentUuid, new RowBounds(0, 1)).stream().findFirst();
    }

    public List<SnapshotDto> selectFinishedByComponentUuidsAndFromDates(DbSession dbSession, List<String> componentUuids, List<Long> fromDates) {
        Preconditions.checkArgument((componentUuids.size() == fromDates.size() ? 1 : 0) != 0, (String)"The number of components (%s) and from dates (%s) must be the same.", (Object[])new Object[]{String.valueOf(componentUuids.size()), String.valueOf(fromDates.size())});
        List componentUuidFromDatePairs = (List)IntStream.range(0, componentUuids.size()).mapToObj(i -> new ComponentUuidFromDatePair((String)componentUuids.get(i), (Long)fromDates.get(i))).collect(MoreCollectors.toList((int)componentUuids.size()));
        return DatabaseUtils.executeLargeInputs((Collection)componentUuidFromDatePairs, partition -> SnapshotDao.mapper(dbSession).selectFinishedByComponentUuidsAndFromDates((List<ComponentUuidFromDatePair>)partition), i -> i / 2);
    }

    public void switchIsLastFlagAndSetProcessedStatus(DbSession dbSession, String componentUuid, String analysisUuid) {
        SnapshotMapper mapper = SnapshotDao.mapper(dbSession);
        mapper.unsetIsLastFlagForComponentUuid(componentUuid);
        SnapshotDao.mapper(dbSession).setIsLastFlagForAnalysisUuid(analysisUuid);
    }

    public SnapshotDto insert(DbSession session, SnapshotDto item) {
        SnapshotDao.mapper(session).insert(item);
        return item;
    }

    public void insert(DbSession session, Collection<SnapshotDto> items) {
        for (SnapshotDto item : items) {
            this.insert(session, item);
        }
    }

    public void insert(DbSession session, SnapshotDto item, SnapshotDto ... others) {
        this.insert(session, Lists.asList((Object)item, (Object[])others));
    }

    public void update(DbSession dbSession, SnapshotDto analysis) {
        SnapshotDao.mapper(dbSession).update(analysis);
    }

    @CheckForNull
    public ViewsSnapshotDto selectSnapshotBefore(String componentUuid, long date, DbSession dbSession) {
        return (ViewsSnapshotDto)FluentIterable.from(SnapshotDao.mapper(dbSession).selectSnapshotBefore(componentUuid, date)).first().orNull();
    }

    private static SnapshotMapper mapper(DbSession session) {
        return (SnapshotMapper)session.getMapper(SnapshotMapper.class);
    }

    static class ComponentUuidFromDatePair
    implements Comparable<ComponentUuidFromDatePair> {
        private final String componentUuid;
        private final long from;

        ComponentUuidFromDatePair(String componentUuid, long from) {
            this.componentUuid = Objects.requireNonNull(componentUuid);
            this.from = from;
        }

        @Override
        public int compareTo(ComponentUuidFromDatePair other) {
            if (this == other) {
                return 0;
            }
            int c = this.componentUuid.compareTo(other.componentUuid);
            if (c == 0) {
                c = Long.compare(this.from, other.from);
            }
            return c;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComponentUuidFromDatePair other = (ComponentUuidFromDatePair)o;
            return this.componentUuid.equals(other.componentUuid) && this.from == other.from;
        }

        public int hashCode() {
            return Objects.hash(this.componentUuid, this.from);
        }
    }
}

