/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.component;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public final class SnapshotDto {
    public static final String STATUS_UNPROCESSED = "U";
    public static final String STATUS_PROCESSED = "P";
    public static final int MAX_VERSION_LENGTH = 100;
    public static final int MAX_BUILD_STRING_LENGTH = 100;
    private Long id;
    private String uuid;
    private String componentUuid;
    private Long createdAt;
    private Long buildDate;
    private String status = "U";
    private Boolean last;
    private String projectVersion;
    private String buildString;
    private String periodMode;
    private String periodParam;
    private Long periodDate;

    public Long getId() {
        return this.id;
    }

    public SnapshotDto setId(Long id) {
        this.id = id;
        return this;
    }

    public SnapshotDto setUuid(String s) {
        this.uuid = s;
        return this;
    }

    public String getUuid() {
        return this.uuid;
    }

    public Long getBuildDate() {
        return this.buildDate;
    }

    public SnapshotDto setBuildDate(Long buildDate) {
        this.buildDate = buildDate;
        return this;
    }

    public String getComponentUuid() {
        return this.componentUuid;
    }

    public SnapshotDto setComponentUuid(String componentUuid) {
        this.componentUuid = componentUuid;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public SnapshotDto setStatus(String status) {
        this.status = status;
        return this;
    }

    public Boolean getLast() {
        return this.last;
    }

    public SnapshotDto setLast(Boolean last) {
        this.last = last;
        return this;
    }

    private static void checkLength(int maxLength, @Nullable String s, String label) {
        if (s != null) {
            Preconditions.checkArgument((s.length() <= maxLength ? 1 : 0) != 0, (String)"%s length (%s) is longer than the maximum authorized (%s). '%s' was provided.", (Object[])new Object[]{label, s.length(), maxLength, s});
        }
    }

    public SnapshotDto setProjectVersion(@Nullable String projectVersion) {
        SnapshotDto.checkLength(100, projectVersion, "projectVersion");
        this.projectVersion = projectVersion;
        return this;
    }

    @CheckForNull
    public String getProjectVersion() {
        return this.projectVersion;
    }

    private void setRawProjectVersion(@Nullable String projectVersion) {
        this.projectVersion = StringUtils.trimToNull((String)projectVersion);
    }

    @CheckForNull
    public String getBuildString() {
        return this.buildString;
    }

    public SnapshotDto setBuildString(@Nullable String buildString) {
        SnapshotDto.checkLength(100, buildString, "buildString");
        this.buildString = buildString;
        return this;
    }

    private void setRawBuildString(@Nullable String buildString) {
        this.buildString = StringUtils.trimToNull((String)buildString);
    }

    public SnapshotDto setPeriodMode(@Nullable String p) {
        this.periodMode = p;
        return this;
    }

    @CheckForNull
    public String getPeriodMode() {
        return this.periodMode;
    }

    public SnapshotDto setPeriodParam(@Nullable String p) {
        this.periodParam = p;
        return this;
    }

    @CheckForNull
    public String getPeriodModeParameter() {
        return this.periodParam;
    }

    public SnapshotDto setPeriodDate(@Nullable Long date) {
        this.periodDate = date;
        return this;
    }

    @CheckForNull
    public Long getPeriodDate() {
        return this.periodDate;
    }

    public SnapshotDto setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotDto that = (SnapshotDto)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.uuid, that.uuid) && Objects.equals(this.componentUuid, that.componentUuid) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.buildDate, that.buildDate) && Objects.equals(this.status, that.status) && Objects.equals(this.last, that.last) && Objects.equals(this.projectVersion, that.projectVersion) && Objects.equals(this.buildString, that.buildString) && Objects.equals(this.periodMode, that.periodMode) && Objects.equals(this.periodParam, that.periodParam) && Objects.equals(this.periodDate, that.periodDate);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.uuid, this.componentUuid, this.createdAt, this.buildDate, this.status, this.last, this.projectVersion, this.buildString, this.periodMode, this.periodParam, this.periodDate);
    }

    public String toString() {
        return "SnapshotDto{id=" + this.id + ", uuid='" + this.uuid + '\'' + ", componentUuid='" + this.componentUuid + '\'' + ", createdAt=" + this.createdAt + ", buildDate=" + this.buildDate + ", status='" + this.status + '\'' + ", last=" + this.last + ", projectVersion='" + this.projectVersion + '\'' + ", buildString='" + this.buildString + '\'' + ", periodMode='" + this.periodMode + '\'' + ", periodParam='" + this.periodParam + '\'' + ", periodDate=" + this.periodDate + '}';
    }
}

