/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.event;

import java.util.List;
import org.sonar.api.utils.System2;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.event.EventComponentChangeDto;
import org.sonar.db.event.EventComponentChangeMapper;
import org.sonar.db.event.EventPurgeData;

public class EventComponentChangeDao
implements Dao {
    private final System2 system2;

    public EventComponentChangeDao(System2 system2) {
        this.system2 = system2;
    }

    public List<EventComponentChangeDto> selectByEventUuid(DbSession dbSession, String eventUuid) {
        return EventComponentChangeDao.getMapper(dbSession).selectByEventUuid(eventUuid);
    }

    public List<EventComponentChangeDto> selectByAnalysisUuids(DbSession dbSession, List<String> analyses) {
        return DatabaseUtils.executeLargeInputs(analyses, EventComponentChangeDao.getMapper(dbSession)::selectByAnalysisUuids);
    }

    public void insert(DbSession dbSession, EventComponentChangeDto dto, EventPurgeData eventPurgeData) {
        EventComponentChangeDao.getMapper(dbSession).insert(dto, eventPurgeData, this.system2.now());
    }

    private static EventComponentChangeMapper getMapper(DbSession dbSession) {
        return (EventComponentChangeMapper)dbSession.getMapper(EventComponentChangeMapper.class);
    }
}

