/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.issue;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.Duration;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.protobuf.DbIssues;
import org.sonar.db.rule.RuleDefinitionDto;

public final class IssueDto
implements Serializable {
    public static final int AUTHOR_MAX_SIZE = 255;
    private static final char TAGS_SEPARATOR = ',';
    private static final Joiner TAGS_JOINER = Joiner.on((char)',').skipNulls();
    private static final Splitter TAGS_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private Long id;
    private int type;
    private String kee;
    private String componentUuid;
    private String projectUuid;
    private Integer ruleId;
    private String severity;
    private boolean manualSeverity;
    private String message;
    private Integer line;
    private Double gap;
    private Long effort;
    private String status;
    private String resolution;
    private String checksum;
    private String assigneeUuid;
    private String authorLogin;
    private String issueAttributes;
    private byte[] locations;
    private long createdAt;
    private long updatedAt;
    private Long issueCreationDate;
    private Long issueUpdateDate;
    private Long issueCloseDate;
    private Long selectedAt;
    private String ruleKey;
    private String ruleRepo;
    private boolean isExternal;
    private String language;
    private String componentKey;
    private String moduleUuid;
    private String moduleUuidPath;
    private String projectKey;
    private String filePath;
    private String tags;
    private boolean isFromHotspot;
    private String closedChangeData;

    public static IssueDto toDtoForComputationInsert(DefaultIssue issue, int ruleId, long now) {
        return new IssueDto().setKee(issue.key()).setType(issue.type()).setLine(issue.line()).setLocations((DbIssues.Locations)issue.getLocations()).setMessage(issue.message()).setGap(issue.gap()).setEffort(issue.effortInMinutes()).setResolution(issue.resolution()).setStatus(issue.status()).setSeverity(issue.severity()).setManualSeverity(issue.manualSeverity()).setChecksum(issue.checksum()).setAssigneeUuid(issue.assignee()).setRuleId(ruleId).setRuleKey(issue.ruleKey().repository(), issue.ruleKey().rule()).setExternal(issue.isFromExternalRuleEngine()).setIsFromHotspot(issue.isFromHotspot()).setTags(issue.tags()).setComponentUuid(issue.componentUuid()).setComponentKey(issue.componentKey()).setModuleUuid(issue.moduleUuid()).setModuleUuidPath(issue.moduleUuidPath()).setProjectUuid(issue.projectUuid()).setProjectKey(issue.projectKey()).setIssueAttributes(KeyValueFormat.format((Map)issue.attributes())).setAuthorLogin(issue.authorLogin()).setIssueCreationDate(issue.creationDate()).setIssueCloseDate(issue.closeDate()).setIssueUpdateDate(issue.updateDate()).setSelectedAt(issue.selectedAt()).setCreatedAt(now).setUpdatedAt(now);
    }

    public static IssueDto toDtoForServerInsert(DefaultIssue issue, ComponentDto component, ComponentDto project, int ruleId, long now) {
        return IssueDto.toDtoForComputationInsert(issue, ruleId, now).setComponent(component).setProject(project);
    }

    public static IssueDto toDtoForUpdate(DefaultIssue issue, long now) {
        return new IssueDto().setKee(issue.key()).setType(issue.type()).setLine(issue.line()).setLocations((DbIssues.Locations)issue.getLocations()).setMessage(issue.message()).setGap(issue.gap()).setEffort(issue.effortInMinutes()).setResolution(issue.resolution()).setStatus(issue.status()).setSeverity(issue.severity()).setChecksum(issue.checksum()).setManualSeverity(issue.manualSeverity()).setAssigneeUuid(issue.assignee()).setIssueAttributes(KeyValueFormat.format((Map)issue.attributes())).setAuthorLogin(issue.authorLogin()).setRuleKey(issue.ruleKey().repository(), issue.ruleKey().rule()).setExternal(issue.isFromExternalRuleEngine()).setIsFromHotspot(issue.isFromHotspot()).setTags(issue.tags()).setComponentUuid(issue.componentUuid()).setComponentKey(issue.componentKey()).setModuleUuid(issue.moduleUuid()).setModuleUuidPath(issue.moduleUuidPath()).setProjectUuid(issue.projectUuid()).setProjectKey(issue.projectKey()).setIssueCreationDate(issue.creationDate()).setIssueCloseDate(issue.closeDate()).setIssueUpdateDate(issue.updateDate()).setSelectedAt(issue.selectedAt()).setUpdatedAt(now);
    }

    public String getKey() {
        return this.getKee();
    }

    public Long getId() {
        return this.id;
    }

    public IssueDto setId(@Nullable Long id) {
        this.id = id;
        return this;
    }

    public String getKee() {
        return this.kee;
    }

    public IssueDto setKee(String s) {
        this.kee = s;
        return this;
    }

    public IssueDto setComponent(ComponentDto component) {
        this.componentKey = component.getDbKey();
        this.componentUuid = component.uuid();
        this.moduleUuid = component.moduleUuid();
        this.moduleUuidPath = component.moduleUuidPath();
        this.filePath = component.path();
        return this;
    }

    public IssueDto setProject(ComponentDto project) {
        this.projectKey = project.getDbKey();
        this.projectUuid = project.uuid();
        return this;
    }

    public Integer getRuleId() {
        return this.ruleId;
    }

    public IssueDto setRuleId(Integer ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    @CheckForNull
    public String getSeverity() {
        return this.severity;
    }

    public IssueDto setSeverity(@Nullable String s) {
        Preconditions.checkArgument((s == null || s.length() <= 10 ? 1 : 0) != 0, (String)"Value is too long for issue severity: %s", (Object[])new Object[]{s});
        this.severity = s;
        return this;
    }

    public boolean isManualSeverity() {
        return this.manualSeverity;
    }

    public IssueDto setManualSeverity(boolean manualSeverity) {
        this.manualSeverity = manualSeverity;
        return this;
    }

    @CheckForNull
    public String getMessage() {
        return this.message;
    }

    public IssueDto setMessage(@Nullable String s) {
        Preconditions.checkArgument((s == null || s.length() <= 4000 ? 1 : 0) != 0, (String)"Value is too long for issue message: %s", (Object[])new Object[]{s});
        this.message = s;
        return this;
    }

    @CheckForNull
    public Integer getLine() {
        return this.line;
    }

    public IssueDto setLine(@Nullable Integer i) {
        Preconditions.checkArgument((i == null || i >= 0 ? 1 : 0) != 0, (String)"Value of issue line must be positive: %d", (Object[])new Object[]{i});
        this.line = i;
        return this;
    }

    @CheckForNull
    public Double getGap() {
        return this.gap;
    }

    public IssueDto setGap(@Nullable Double d) {
        Preconditions.checkArgument((d == null || d >= 0.0 ? 1 : 0) != 0, (String)"Value of issue gap must be positive: %d", (Object[])new Object[]{d});
        this.gap = d;
        return this;
    }

    @CheckForNull
    public Long getEffort() {
        return this.effort;
    }

    public IssueDto setEffort(@Nullable Long l) {
        Preconditions.checkArgument((l == null || l >= 0L ? 1 : 0) != 0, (String)"Value of issue effort must be positive: %d", (Object[])new Object[]{l});
        this.effort = l;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public IssueDto setStatus(@Nullable String s) {
        Preconditions.checkArgument((s == null || s.length() <= 20 ? 1 : 0) != 0, (String)"Value is too long for issue status: %s", (Object[])new Object[]{s});
        this.status = s;
        return this;
    }

    @CheckForNull
    public String getResolution() {
        return this.resolution;
    }

    public IssueDto setResolution(@Nullable String s) {
        Preconditions.checkArgument((s == null || s.length() <= 20 ? 1 : 0) != 0, (String)"Value is too long for issue resolution: %s", (Object[])new Object[]{s});
        this.resolution = s;
        return this;
    }

    @CheckForNull
    public String getChecksum() {
        return this.checksum;
    }

    public IssueDto setChecksum(@Nullable String s) {
        Preconditions.checkArgument((s == null || s.length() <= 1000 ? 1 : 0) != 0, (String)"Value is too long for issue checksum: %s", (Object[])new Object[]{s});
        this.checksum = s;
        return this;
    }

    @CheckForNull
    public String getAssigneeUuid() {
        return this.assigneeUuid;
    }

    public IssueDto setAssigneeUuid(@Nullable String s) {
        Preconditions.checkArgument((s == null || s.length() <= 255 ? 1 : 0) != 0, (String)"Value is too long for issue assigneeUuid: %s", (Object[])new Object[]{s});
        this.assigneeUuid = s;
        return this;
    }

    @CheckForNull
    public String getAuthorLogin() {
        return this.authorLogin;
    }

    public IssueDto setAuthorLogin(@Nullable String s) {
        Preconditions.checkArgument((s == null || s.length() <= 255 ? 1 : 0) != 0, (String)"Value is too long for issue author login: %s", (Object[])new Object[]{s});
        this.authorLogin = s;
        return this;
    }

    @CheckForNull
    public String getIssueAttributes() {
        return this.issueAttributes;
    }

    public IssueDto setIssueAttributes(@Nullable String s) {
        Preconditions.checkArgument((s == null || s.length() <= 4000 ? 1 : 0) != 0, (String)"Value is too long for issue attributes: %s", (Object[])new Object[]{s});
        this.issueAttributes = s;
        return this;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public IssueDto setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public IssueDto setUpdatedAt(long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public Long getIssueCreationTime() {
        return this.issueCreationDate;
    }

    public IssueDto setIssueCreationTime(Long time) {
        this.issueCreationDate = time;
        return this;
    }

    public Date getIssueCreationDate() {
        return DateUtils.longToDate((Long)this.issueCreationDate);
    }

    public IssueDto setIssueCreationDate(@Nullable Date d) {
        this.issueCreationDate = DateUtils.dateToLong((Date)d);
        return this;
    }

    public Long getIssueUpdateTime() {
        return this.issueUpdateDate;
    }

    public IssueDto setIssueUpdateTime(Long time) {
        this.issueUpdateDate = time;
        return this;
    }

    public Date getIssueUpdateDate() {
        return DateUtils.longToDate((Long)this.issueUpdateDate);
    }

    public IssueDto setIssueUpdateDate(@Nullable Date d) {
        this.issueUpdateDate = DateUtils.dateToLong((Date)d);
        return this;
    }

    public Long getIssueCloseTime() {
        return this.issueCloseDate;
    }

    public IssueDto setIssueCloseTime(Long time) {
        this.issueCloseDate = time;
        return this;
    }

    public Date getIssueCloseDate() {
        return DateUtils.longToDate((Long)this.issueCloseDate);
    }

    public IssueDto setIssueCloseDate(@Nullable Date d) {
        this.issueCloseDate = DateUtils.dateToLong((Date)d);
        return this;
    }

    public String getRule() {
        return this.ruleKey;
    }

    public IssueDto setRule(RuleDefinitionDto rule) {
        Preconditions.checkNotNull((Object)rule.getId(), (Object)"Rule must be persisted.");
        this.ruleId = rule.getId();
        this.ruleKey = rule.getRuleKey();
        this.ruleRepo = rule.getRepositoryKey();
        this.language = rule.getLanguage();
        this.isExternal = rule.isExternal();
        return this;
    }

    public String getRuleRepo() {
        return this.ruleRepo;
    }

    public RuleKey getRuleKey() {
        return RuleKey.of((String)this.ruleRepo, (String)this.ruleKey);
    }

    public String getLanguage() {
        return this.language;
    }

    public IssueDto setLanguage(String language) {
        this.language = language;
        return this;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public IssueDto setExternal(boolean external) {
        this.isExternal = external;
        return this;
    }

    public boolean isFromHotspot() {
        return this.isFromHotspot;
    }

    public IssueDto setIsFromHotspot(boolean value) {
        this.isFromHotspot = value;
        return this;
    }

    public String getComponentKey() {
        return this.componentKey;
    }

    public IssueDto setComponentKey(String componentKey) {
        this.componentKey = componentKey;
        return this;
    }

    @CheckForNull
    public String getComponentUuid() {
        return this.componentUuid;
    }

    public IssueDto setComponentUuid(@Nullable String s) {
        Preconditions.checkArgument((s == null || s.length() <= 50 ? 1 : 0) != 0, (String)"Value is too long for column ISSUES.COMPONENT_UUID: %s", (Object[])new Object[]{s});
        this.componentUuid = s;
        return this;
    }

    @CheckForNull
    public String getModuleUuid() {
        return this.moduleUuid;
    }

    public IssueDto setModuleUuid(@Nullable String moduleUuid) {
        this.moduleUuid = moduleUuid;
        return this;
    }

    @CheckForNull
    public String getModuleUuidPath() {
        return this.moduleUuidPath;
    }

    public IssueDto setModuleUuidPath(@Nullable String moduleUuidPath) {
        this.moduleUuidPath = moduleUuidPath;
        return this;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public IssueDto setProjectKey(String projectKey) {
        this.projectKey = projectKey;
        return this;
    }

    public String getProjectUuid() {
        return this.projectUuid;
    }

    public IssueDto setProjectUuid(String s) {
        Preconditions.checkArgument((s.length() <= 50 ? 1 : 0) != 0, (String)"Value is too long for column ISSUES.PROJECT_UUID: %s", (Object[])new Object[]{s});
        this.projectUuid = s;
        return this;
    }

    @CheckForNull
    public Long getSelectedAt() {
        return this.selectedAt;
    }

    public IssueDto setSelectedAt(@Nullable Long d) {
        this.selectedAt = d;
        return this;
    }

    public IssueDto setRuleKey(String repo, String rule) {
        this.ruleRepo = repo;
        this.ruleKey = rule;
        return this;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public IssueDto setFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    public Set<String> getTags() {
        return ImmutableSet.copyOf((Iterable)TAGS_SPLITTER.split((CharSequence)(this.tags == null ? "" : this.tags)));
    }

    public IssueDto setTags(@Nullable Collection<String> tags) {
        if (tags == null || tags.isEmpty()) {
            this.setTagsString(null);
        } else {
            this.setTagsString(TAGS_JOINER.join(tags));
        }
        return this;
    }

    public IssueDto setTagsString(@Nullable String s) {
        Preconditions.checkArgument((s == null || s.length() <= 4000 ? 1 : 0) != 0, (String)"Value is too long for column ISSUES.TAGS: %s", (Object[])new Object[]{s});
        this.tags = s;
        return this;
    }

    public String getTagsString() {
        return this.tags;
    }

    @CheckForNull
    public byte[] getLocations() {
        return this.locations;
    }

    @CheckForNull
    public DbIssues.Locations parseLocations() {
        if (this.locations != null) {
            try {
                return DbIssues.Locations.parseFrom(this.locations);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalStateException(String.format("Fail to read ISSUES.LOCATIONS [KEE=%s]", this.kee), e);
            }
        }
        return null;
    }

    public IssueDto setLocations(@Nullable byte[] locations) {
        this.locations = locations;
        return this;
    }

    public IssueDto setLocations(@Nullable DbIssues.Locations locations) {
        this.locations = (byte[])(locations == null ? null : locations.toByteArray());
        return this;
    }

    public int getType() {
        return this.type;
    }

    public IssueDto setType(int type) {
        this.type = type;
        return this;
    }

    public IssueDto setType(RuleType type) {
        this.type = type.getDbConstant();
        return this;
    }

    public Optional<String> getClosedChangeData() {
        return Optional.ofNullable(this.closedChangeData);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public DefaultIssue toDefaultIssue() {
        DefaultIssue issue = new DefaultIssue();
        issue.setKey(this.kee);
        issue.setType(RuleType.valueOf((int)this.type));
        issue.setStatus(this.status);
        issue.setResolution(this.resolution);
        issue.setMessage(this.message);
        issue.setGap(this.gap);
        issue.setEffort(this.effort != null ? Duration.create((long)this.effort) : null);
        issue.setLine(this.line);
        issue.setChecksum(this.checksum);
        issue.setSeverity(this.severity);
        issue.setAssigneeUuid(this.assigneeUuid);
        issue.setAttributes(KeyValueFormat.parse((String)((String)MoreObjects.firstNonNull((Object)this.issueAttributes, (Object)""))));
        issue.setComponentKey(this.componentKey);
        issue.setComponentUuid(this.componentUuid);
        issue.setModuleUuid(this.moduleUuid);
        issue.setModuleUuidPath(this.moduleUuidPath);
        issue.setProjectUuid(this.projectUuid);
        issue.setProjectKey(this.projectKey);
        issue.setManualSeverity(this.manualSeverity);
        issue.setRuleKey(this.getRuleKey());
        issue.setTags(this.getTags());
        issue.setLanguage(this.language);
        issue.setAuthorLogin(this.authorLogin);
        issue.setNew(false);
        issue.setCreationDate(DateUtils.longToDate((Long)this.issueCreationDate));
        issue.setCloseDate(DateUtils.longToDate((Long)this.issueCloseDate));
        issue.setUpdateDate(DateUtils.longToDate((Long)this.issueUpdateDate));
        issue.setSelectedAt(this.selectedAt);
        issue.setLocations((Object)this.parseLocations());
        issue.setIsFromExternalRuleEngine(this.isExternal);
        issue.setIsFromHotspot(this.isFromHotspot);
        return issue;
    }
}

