/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.measure;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.core.util.CloseableIterator;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;

public class ProjectMeasuresIndexerIterator
extends CloseableIterator<ProjectMeasures> {
    public static final Set<String> METRIC_KEYS = ImmutableSortedSet.of((Comparable)((Object)"ncloc"), (Comparable)((Object)"lines"), (Comparable)((Object)"duplicated_lines_density"), (Comparable)((Object)"coverage"), (Comparable)((Object)"sqale_rating"), (Comparable)((Object)"reliability_rating"), (Comparable[])new String[]{"security_rating", "alert_status", "ncloc_language_distribution", "new_security_rating", "new_maintainability_rating", "new_coverage", "new_duplicated_lines_density", "new_lines", "new_reliability_rating"});
    private static final String SQL_PROJECTS = "SELECT p.organization_uuid, p.uuid, p.kee, p.name, s.created_at, p.tags FROM projects p LEFT OUTER JOIN snapshots s ON s.component_uuid=p.uuid AND s.islast=? WHERE p.enabled=? AND p.scope=? AND p.qualifier=? and p.main_branch_project_uuid is null ";
    private static final String PROJECT_FILTER = " AND p.uuid=?";
    private static final String SQL_MEASURES = "SELECT m.name, pm.value, pm.variation, pm.text_value FROM live_measures pm INNER JOIN metrics m ON m.id = pm.metric_id WHERE pm.component_uuid = ? AND m.name IN ({metricNames}) AND (pm.value IS NOT NULL OR pm.variation IS NOT NULL OR pm.text_value IS NOT NULL) AND m.enabled = ? ";
    private static final boolean ENABLED = true;
    private static final int FIELD_METRIC_NAME = 1;
    private static final int FIELD_MEASURE_VALUE = 2;
    private static final int FIELD_MEASURE_VARIATION = 3;
    private static final int FIELD_MEASURE_TEXT_VALUE = 4;
    private final PreparedStatement measuresStatement;
    private final Iterator<Project> projects;

    private ProjectMeasuresIndexerIterator(PreparedStatement measuresStatement, List<Project> projects) {
        this.measuresStatement = measuresStatement;
        this.projects = projects.iterator();
    }

    public static ProjectMeasuresIndexerIterator create(DbSession session, @Nullable String projectUuid) {
        List<Project> projects = ProjectMeasuresIndexerIterator.selectProjects(session, projectUuid);
        PreparedStatement projectsStatement = ProjectMeasuresIndexerIterator.createMeasuresStatement(session);
        return new ProjectMeasuresIndexerIterator(projectsStatement, projects);
    }

    /*
     * Exception decompiling
     */
    private static List<Project> selectProjects(DbSession session, @Nullable String projectUuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static PreparedStatement createProjectsStatement(DbSession session, @Nullable String projectUuid) {
        try {
            StringBuilder sql = new StringBuilder(SQL_PROJECTS);
            if (projectUuid != null) {
                sql.append(PROJECT_FILTER);
            }
            PreparedStatement stmt = session.getConnection().prepareStatement(sql.toString());
            stmt.setBoolean(1, true);
            stmt.setBoolean(2, true);
            stmt.setString(3, "PRJ");
            stmt.setString(4, "TRK");
            if (projectUuid != null) {
                stmt.setString(5, projectUuid);
            }
            return stmt;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Fail to prepare SQL request to select all project measures", e);
        }
    }

    private static PreparedStatement createMeasuresStatement(DbSession session) {
        try {
            String metricNameQuestionMarks = METRIC_KEYS.stream().map(x -> "?").collect(Collectors.joining(","));
            String sql = StringUtils.replace((String)SQL_MEASURES, (String)"{metricNames}", (String)metricNameQuestionMarks);
            return session.getConnection().prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Fail to prepare SQL request to select measures", e);
        }
    }

    @CheckForNull
    protected ProjectMeasures doNext() {
        if (!this.projects.hasNext()) {
            return null;
        }
        Project project = this.projects.next();
        Measures measures = this.selectMeasures(project.getUuid());
        return new ProjectMeasures(project, measures);
    }

    private Measures selectMeasures(String projectUuid) {
        Measures measures;
        Measures measures2 = new Measures();
        ResultSet rs = null;
        try {
            AtomicInteger index = new AtomicInteger(1);
            this.measuresStatement.setString(index.getAndIncrement(), projectUuid);
            METRIC_KEYS.forEach(DatabaseUtils.setStrings((PreparedStatement)this.measuresStatement, index::getAndIncrement));
            this.measuresStatement.setBoolean(index.getAndIncrement(), true);
            rs = this.measuresStatement.executeQuery();
            while (rs.next()) {
                ProjectMeasuresIndexerIterator.readMeasure(rs, measures2);
            }
            measures = measures2;
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(String.format("Fail to execute request to select measures of project %s", projectUuid), e);
            }
            catch (Throwable throwable) {
                DatabaseUtils.closeQuietly(rs);
                throw throwable;
            }
        }
        DatabaseUtils.closeQuietly((ResultSet)rs);
        return measures;
    }

    private static void readMeasure(ResultSet rs, Measures measures) throws SQLException {
        Optional<Double> value;
        String metricKey = rs.getString(1);
        Optional<Double> optional = value = metricKey.startsWith("new_") ? ProjectMeasuresIndexerIterator.getDouble(rs, 3) : ProjectMeasuresIndexerIterator.getDouble(rs, 2);
        if (value.isPresent()) {
            measures.addNumericMeasure(metricKey, value.get());
            return;
        }
        if ("alert_status".equals(metricKey)) {
            ProjectMeasuresIndexerIterator.readTextValue(rs, measures::setQualityGateStatus);
            return;
        }
        if ("ncloc_language_distribution".equals(metricKey)) {
            ProjectMeasuresIndexerIterator.readTextValue(rs, measures::setNclocByLanguages);
            return;
        }
    }

    private static void readTextValue(ResultSet rs, Consumer<String> action) throws SQLException {
        String textValue = rs.getString(4);
        if (!rs.wasNull()) {
            action.accept(textValue);
        }
    }

    protected void doClose() throws Exception {
        this.measuresStatement.close();
    }

    private static Optional<Double> getDouble(ResultSet rs, int index) {
        try {
            Double value = rs.getDouble(index);
            if (!rs.wasNull()) {
                return Optional.of(value);
            }
            return Optional.empty();
        }
        catch (SQLException e) {
            throw new IllegalStateException("Fail to get double value", e);
        }
    }

    public static class ProjectMeasures {
        private Project project;
        private Measures measures;

        public ProjectMeasures(Project project, Measures measures) {
            this.project = project;
            this.measures = measures;
        }

        public Project getProject() {
            return this.project;
        }

        public Measures getMeasures() {
            return this.measures;
        }
    }

    public static class Measures {
        private Map<String, Double> numericMeasures = new HashMap<String, Double>();
        private String qualityGateStatus;
        private Map<String, Integer> nclocByLanguages = new LinkedHashMap<String, Integer>();

        Measures addNumericMeasure(String metricKey, double value) {
            this.numericMeasures.put(metricKey, value);
            return this;
        }

        public Map<String, Double> getNumericMeasures() {
            return this.numericMeasures;
        }

        Measures setQualityGateStatus(@Nullable String qualityGateStatus) {
            this.qualityGateStatus = qualityGateStatus;
            return this;
        }

        @CheckForNull
        public String getQualityGateStatus() {
            return this.qualityGateStatus;
        }

        Measures setNclocByLanguages(String nclocByLangues) {
            this.nclocByLanguages = ImmutableMap.copyOf((Map)KeyValueFormat.parseStringInt((String)nclocByLangues));
            return this;
        }

        public Map<String, Integer> getNclocByLanguages() {
            return this.nclocByLanguages;
        }
    }

    public static class Project {
        private final String organizationUuid;
        private final String uuid;
        private final String key;
        private final String name;
        private final Long analysisDate;
        private final List<String> tags;

        public Project(String organizationUuid, String uuid, String key, String name, List<String> tags, @Nullable Long analysisDate) {
            this.organizationUuid = organizationUuid;
            this.uuid = uuid;
            this.key = key;
            this.name = name;
            this.tags = tags;
            this.analysisDate = analysisDate;
        }

        public String getOrganizationUuid() {
            return this.organizationUuid;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getTags() {
            return this.tags;
        }

        @CheckForNull
        public Long getAnalysisDate() {
            return this.analysisDate;
        }
    }
}

