/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.notification;

import java.util.Collections;
import java.util.List;
import org.sonar.db.Dao;
import org.sonar.db.DbSession;
import org.sonar.db.MyBatis;
import org.sonar.db.notification.NotificationQueueDto;
import org.sonar.db.notification.NotificationQueueMapper;

public class NotificationQueueDao
implements Dao {
    private final MyBatis mybatis;

    public NotificationQueueDao(MyBatis mybatis) {
        this.mybatis = mybatis;
    }

    public void insert(List<NotificationQueueDto> dtos) {
        try (DbSession session = this.mybatis.openSession(true);){
            NotificationQueueMapper mapper = (NotificationQueueMapper)session.getMapper(NotificationQueueMapper.class);
            for (NotificationQueueDto dto : dtos) {
                mapper.insert(dto);
            }
            session.commit();
        }
    }

    public void delete(List<NotificationQueueDto> dtos) {
        try (DbSession session = this.mybatis.openSession(true);){
            NotificationQueueMapper mapper = (NotificationQueueMapper)session.getMapper(NotificationQueueMapper.class);
            for (NotificationQueueDto dto : dtos) {
                mapper.delete(dto.getId());
            }
            session.commit();
        }
    }

    public List<NotificationQueueDto> selectOldest(int count) {
        if (count < 1) {
            return Collections.emptyList();
        }
        try (DbSession session = this.mybatis.openSession(false);){
            List<NotificationQueueDto> list = ((NotificationQueueMapper)session.getMapper(NotificationQueueMapper.class)).findOldest(count);
            return list;
        }
    }

    public long count() {
        try (DbSession session = this.mybatis.openSession(false);){
            long l = ((NotificationQueueMapper)session.getMapper(NotificationQueueMapper.class)).count();
            return l;
        }
    }
}

