/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.organization;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationMemberDto;
import org.sonar.db.organization.OrganizationMemberMapper;

public class OrganizationMemberDao
implements Dao {
    private static OrganizationMemberMapper mapper(DbSession dbSession) {
        return (OrganizationMemberMapper)dbSession.getMapper(OrganizationMemberMapper.class);
    }

    public Optional<OrganizationMemberDto> select(DbSession dbSession, String organizationUuid, int userId) {
        return Optional.ofNullable(OrganizationMemberDao.mapper(dbSession).select(organizationUuid, userId));
    }

    public List<String> selectUserUuidsByOrganizationUuid(DbSession dbSession, String organizationUuid) {
        return OrganizationMemberDao.mapper(dbSession).selectUserUuids(organizationUuid);
    }

    public List<Integer> selectUserIdsByOrganizationUuid(DbSession dbSession, String organizationUuid) {
        return OrganizationMemberDao.mapper(dbSession).selectUserIds(organizationUuid);
    }

    public void insert(DbSession dbSession, OrganizationMemberDto organizationMemberDto) {
        OrganizationMemberDao.mapper(dbSession).insert(organizationMemberDto);
    }

    public void delete(DbSession dbSession, String organizationMemberUuid, Integer userId) {
        OrganizationMemberDao.mapper(dbSession).delete(organizationMemberUuid, userId);
    }

    public void deleteByOrganizationUuid(DbSession dbSession, String organizationMemberUuid) {
        OrganizationMemberDao.mapper(dbSession).deleteByOrganization(organizationMemberUuid);
    }

    public void deleteByUserId(DbSession dbSession, int userId) {
        OrganizationMemberDao.mapper(dbSession).deleteByUserId(userId);
    }

    public Set<String> selectOrganizationUuidsByUser(DbSession dbSession, int userId) {
        return OrganizationMemberDao.mapper(dbSession).selectOrganizationUuidsByUser(userId);
    }

    public void selectForUserIndexing(DbSession dbSession, Collection<String> uuids, BiConsumer<String, String> userUuidOrganizationConsumer) {
        DatabaseUtils.executeLargeInputsWithoutOutput(uuids, list -> OrganizationMemberDao.mapper(dbSession).selectForIndexing((List<String>)list).forEach(row -> userUuidOrganizationConsumer.accept((String)row.get("uuid"), (String)row.get("organizationUuid"))));
    }

    public void selectAllForUserIndexing(DbSession dbSession, BiConsumer<String, String> userUuidOrganizationConsumer) {
        OrganizationMemberDao.mapper(dbSession).selectAllForIndexing().forEach(row -> userUuidOrganizationConsumer.accept((String)row.get("uuid"), (String)row.get("organizationUuid")));
    }
}

