/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.permission;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.permission.AuthorizationMapper;
import org.sonar.db.permission.OrganizationPermission;

public class AuthorizationDao
implements Dao {
    public Set<String> selectOrganizationPermissions(DbSession dbSession, String organizationUuid, int userId) {
        return AuthorizationDao.mapper(dbSession).selectOrganizationPermissions(organizationUuid, userId);
    }

    public Set<String> selectOrganizationPermissionsOfAnonymous(DbSession dbSession, String organizationUuid) {
        return AuthorizationDao.mapper(dbSession).selectOrganizationPermissionsOfAnonymous(organizationUuid);
    }

    public Set<String> selectProjectPermissions(DbSession dbSession, String projectUuid, long userId) {
        return AuthorizationDao.mapper(dbSession).selectProjectPermissions(projectUuid, userId);
    }

    public Set<String> selectProjectPermissionsOfAnonymous(DbSession dbSession, String projectUuid) {
        return AuthorizationDao.mapper(dbSession).selectProjectPermissionsOfAnonymous(projectUuid);
    }

    public int countUsersWithGlobalPermissionExcludingGroup(DbSession dbSession, String organizationUuid, String permission, int excludedGroupId) {
        return AuthorizationDao.mapper(dbSession).countUsersWithGlobalPermissionExcludingGroup(organizationUuid, permission, excludedGroupId);
    }

    public int countUsersWithGlobalPermissionExcludingUser(DbSession dbSession, String organizationUuid, String permission, int excludedUserId) {
        return AuthorizationDao.mapper(dbSession).countUsersWithGlobalPermissionExcludingUser(organizationUuid, permission, excludedUserId);
    }

    public List<Integer> selectUserIdsWithGlobalPermission(DbSession dbSession, String organizationUuid, String permission) {
        return AuthorizationDao.mapper(dbSession).selectUserIdsWithGlobalPermission(organizationUuid, permission);
    }

    public int countUsersWithGlobalPermissionExcludingGroupMember(DbSession dbSession, String organizationUuid, String permission, int groupId, int userId) {
        return AuthorizationDao.mapper(dbSession).countUsersWithGlobalPermissionExcludingGroupMember(organizationUuid, permission, groupId, userId);
    }

    public int countUsersWithGlobalPermissionExcludingUserPermission(DbSession dbSession, String organizationUuid, String permission, int userId) {
        return AuthorizationDao.mapper(dbSession).countUsersWithGlobalPermissionExcludingUserPermission(organizationUuid, permission, userId);
    }

    public Set<String> selectOrganizationUuidsOfUserWithGlobalPermission(DbSession dbSession, int userId, String permission) {
        return AuthorizationDao.mapper(dbSession).selectOrganizationUuidsOfUserWithGlobalPermission(userId, permission);
    }

    @Deprecated
    public Set<Long> keepAuthorizedProjectIds(DbSession dbSession, Collection<Long> componentIds, @Nullable Integer userId, String permission) {
        return DatabaseUtils.executeLargeInputsIntoSet(componentIds, partition -> {
            if (userId == null) {
                return AuthorizationDao.mapper(dbSession).keepAuthorizedProjectIdsForAnonymous(permission, (Collection<Long>)partition);
            }
            return AuthorizationDao.mapper(dbSession).keepAuthorizedProjectIdsForUser(userId, permission, (Collection<Long>)partition);
        }, partitionSize -> partitionSize / 2);
    }

    public Set<String> keepAuthorizedProjectUuids(DbSession dbSession, Collection<String> projectUuids, @Nullable Integer userId, String permission) {
        return DatabaseUtils.executeLargeInputsIntoSet(projectUuids, partition -> {
            if (userId == null) {
                return AuthorizationDao.mapper(dbSession).keepAuthorizedProjectUuidsForAnonymous(permission, (Collection<String>)partition);
            }
            return AuthorizationDao.mapper(dbSession).keepAuthorizedProjectUuidsForUser(userId, permission, (Collection<String>)partition);
        }, partitionSize -> partitionSize / 2);
    }

    public Collection<Integer> keepAuthorizedUsersForRoleAndProject(DbSession dbSession, Collection<Integer> userIds, String role, long projectId) {
        return DatabaseUtils.executeLargeInputs(userIds, partitionOfIds -> AuthorizationDao.mapper(dbSession).keepAuthorizedUsersForRoleAndProject(role, projectId, (List<Integer>)partitionOfIds), partitionSize -> partitionSize / 3);
    }

    public List<String> selectQualityProfileAdministratorLogins(DbSession dbSession) {
        return AuthorizationDao.mapper(dbSession).selectLoginsWithGlobalPermission(OrganizationPermission.ADMINISTER_QUALITY_PROFILES.getKey());
    }

    public List<String> selectGlobalAdministratorLogins(DbSession dbSession) {
        return AuthorizationDao.mapper(dbSession).selectLoginsWithGlobalPermission(OrganizationPermission.ADMINISTER.getKey());
    }

    public Set<String> keepAuthorizedLoginsOnProject(DbSession dbSession, Set<String> logins, String projectKey, String permission) {
        return DatabaseUtils.executeLargeInputsIntoSet(logins, partitionOfLogins -> AuthorizationDao.mapper(dbSession).keepAuthorizedLoginsOnProject((List<String>)partitionOfLogins, projectKey, permission), partitionSize -> partitionSize / 3);
    }

    private static AuthorizationMapper mapper(DbSession dbSession) {
        return (AuthorizationMapper)dbSession.getMapper(AuthorizationMapper.class);
    }
}

