/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.qualityprofile;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.ibatis.session.ResultHandler;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.KeyLongValue;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.ActiveRuleCountQuery;
import org.sonar.db.qualityprofile.ActiveRuleDto;
import org.sonar.db.qualityprofile.ActiveRuleKey;
import org.sonar.db.qualityprofile.ActiveRuleMapper;
import org.sonar.db.qualityprofile.ActiveRuleParamDto;
import org.sonar.db.qualityprofile.IndexedActiveRuleDto;
import org.sonar.db.qualityprofile.OrgActiveRuleDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.qualityprofile.RulesProfileDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.rule.RuleParamDto;

public class ActiveRuleDao
implements Dao {
    private static final String QUALITY_PROFILE_IS_NOT_PERSISTED = "Quality profile is not persisted (missing id)";
    private static final String RULE_IS_NOT_PERSISTED = "Rule is not persisted";
    private static final String RULE_PARAM_IS_NOT_PERSISTED = "Rule param is not persisted";
    private static final String ACTIVE_RULE_IS_NOT_PERSISTED = "ActiveRule is not persisted";
    private static final String ACTIVE_RULE_IS_ALREADY_PERSISTED = "ActiveRule is already persisted";
    private static final String ACTIVE_RULE_PARAM_IS_NOT_PERSISTED = "ActiveRuleParam is not persisted";
    private static final String ACTIVE_RULE_PARAM_IS_ALREADY_PERSISTED = "ActiveRuleParam is already persisted";

    public Optional<ActiveRuleDto> selectByKey(DbSession dbSession, ActiveRuleKey key) {
        return Optional.ofNullable(ActiveRuleDao.mapper(dbSession).selectByKey(key.getRuleProfileUuid(), key.getRuleKey().repository(), key.getRuleKey().rule()));
    }

    public List<OrgActiveRuleDto> selectByRuleId(DbSession dbSession, OrganizationDto organization, int ruleId) {
        return ActiveRuleDao.mapper(dbSession).selectByRuleId(organization.getUuid(), ruleId);
    }

    public List<ActiveRuleDto> selectByRuleIdOfAllOrganizations(DbSession dbSession, int ruleId) {
        return ActiveRuleDao.mapper(dbSession).selectByRuleIdOfAllOrganizations(ruleId);
    }

    public List<OrgActiveRuleDto> selectByRuleIds(DbSession dbSession, OrganizationDto organization, List<Integer> ids) {
        return DatabaseUtils.executeLargeInputs(ids, chunk -> ActiveRuleDao.mapper(dbSession).selectByRuleIds(organization.getUuid(), (List<Integer>)chunk));
    }

    public List<OrgActiveRuleDto> selectByProfileUuid(DbSession dbSession, String uuid) {
        return ActiveRuleDao.mapper(dbSession).selectByProfileUuid(uuid);
    }

    public List<OrgActiveRuleDto> selectByTypeAndProfileUuids(DbSession dbSession, List<Integer> types, List<String> uuids) {
        return DatabaseUtils.executeLargeInputs(uuids, chunk -> ActiveRuleDao.mapper(dbSession).selectByTypeAndProfileUuids(types, (List<String>)chunk));
    }

    public List<OrgActiveRuleDto> selectByProfile(DbSession dbSession, QProfileDto profile) {
        return this.selectByProfileUuid(dbSession, profile.getKee());
    }

    public List<ActiveRuleDto> selectByRuleProfile(DbSession dbSession, RulesProfileDto ruleProfileDto) {
        return ActiveRuleDao.mapper(dbSession).selectByRuleProfileUuid(ruleProfileDto.getKee());
    }

    public Collection<ActiveRuleDto> selectByRulesAndRuleProfileUuids(DbSession dbSession, Collection<RuleDefinitionDto> rules, Collection<String> ruleProfileUuids) {
        if (rules.isEmpty() || ruleProfileUuids.isEmpty()) {
            return Collections.emptyList();
        }
        List ruleIds = (List)rules.stream().map(RuleDefinitionDto::getId).collect(MoreCollectors.toArrayList((int)rules.size()));
        ActiveRuleMapper mapper = ActiveRuleDao.mapper(dbSession);
        return DatabaseUtils.executeLargeInputs((Collection)ruleIds, ruleIdsChunk -> DatabaseUtils.executeLargeInputs((Collection)ruleProfileUuids, chunk -> mapper.selectByRuleIdsAndRuleProfileUuids((Collection<Integer>)ruleIdsChunk, (Collection<String>)chunk)));
    }

    public ActiveRuleDto insert(DbSession dbSession, ActiveRuleDto item) {
        Preconditions.checkArgument((item.getProfileId() != null ? 1 : 0) != 0, (Object)QUALITY_PROFILE_IS_NOT_PERSISTED);
        Preconditions.checkArgument((item.getRuleId() != null ? 1 : 0) != 0, (Object)RULE_IS_NOT_PERSISTED);
        Preconditions.checkArgument((item.getId() == null ? 1 : 0) != 0, (Object)ACTIVE_RULE_IS_ALREADY_PERSISTED);
        ActiveRuleDao.mapper(dbSession).insert(item);
        return item;
    }

    public ActiveRuleDto update(DbSession dbSession, ActiveRuleDto item) {
        Preconditions.checkArgument((item.getProfileId() != null ? 1 : 0) != 0, (Object)QUALITY_PROFILE_IS_NOT_PERSISTED);
        Preconditions.checkArgument((item.getRuleId() != null ? 1 : 0) != 0, (Object)RULE_IS_NOT_PERSISTED);
        Preconditions.checkArgument((item.getId() != null ? 1 : 0) != 0, (Object)ACTIVE_RULE_IS_NOT_PERSISTED);
        ActiveRuleDao.mapper(dbSession).update(item);
        return item;
    }

    public Optional<ActiveRuleDto> delete(DbSession dbSession, ActiveRuleKey key) {
        Optional<ActiveRuleDto> activeRule = this.selectByKey(dbSession, key);
        if (activeRule.isPresent()) {
            ActiveRuleDao.mapper(dbSession).deleteParameters(activeRule.get().getId());
            ActiveRuleDao.mapper(dbSession).delete(activeRule.get().getId());
        }
        return activeRule;
    }

    public void deleteByRuleProfileUuids(DbSession dbSession, Collection<String> rulesProfileUuids) {
        ActiveRuleMapper mapper = ActiveRuleDao.mapper(dbSession);
        DatabaseUtils.executeLargeUpdates(rulesProfileUuids, mapper::deleteByRuleProfileUuids);
    }

    public void deleteByIds(DbSession dbSession, List<Integer> activeRuleIds) {
        ActiveRuleMapper mapper = ActiveRuleDao.mapper(dbSession);
        DatabaseUtils.executeLargeUpdates(activeRuleIds, mapper::deleteByIds);
    }

    public void deleteParametersByRuleProfileUuids(DbSession dbSession, Collection<String> rulesProfileUuids) {
        ActiveRuleMapper mapper = ActiveRuleDao.mapper(dbSession);
        DatabaseUtils.executeLargeUpdates(rulesProfileUuids, mapper::deleteParametersByRuleProfileUuids);
    }

    public List<ActiveRuleParamDto> selectParamsByActiveRuleId(DbSession dbSession, Integer activeRuleId) {
        return ActiveRuleDao.mapper(dbSession).selectParamsByActiveRuleId(activeRuleId);
    }

    public List<ActiveRuleParamDto> selectParamsByActiveRuleIds(DbSession dbSession, List<Integer> activeRuleIds) {
        return DatabaseUtils.executeLargeInputs(activeRuleIds, ActiveRuleDao.mapper(dbSession)::selectParamsByActiveRuleIds);
    }

    public ActiveRuleParamDto insertParam(DbSession dbSession, ActiveRuleDto activeRule, ActiveRuleParamDto activeRuleParam) {
        Preconditions.checkArgument((activeRule.getId() != null ? 1 : 0) != 0, (Object)ACTIVE_RULE_IS_NOT_PERSISTED);
        Preconditions.checkArgument((activeRuleParam.getId() == null ? 1 : 0) != 0, (Object)ACTIVE_RULE_PARAM_IS_ALREADY_PERSISTED);
        Preconditions.checkNotNull((Object)activeRuleParam.getRulesParameterId(), (Object)RULE_PARAM_IS_NOT_PERSISTED);
        activeRuleParam.setActiveRuleId(activeRule.getId());
        ActiveRuleDao.mapper(dbSession).insertParameter(activeRuleParam);
        return activeRuleParam;
    }

    public void updateParam(DbSession dbSession, ActiveRuleParamDto activeRuleParam) {
        Preconditions.checkNotNull((Object)activeRuleParam.getId(), (Object)ACTIVE_RULE_PARAM_IS_NOT_PERSISTED);
        ActiveRuleDao.mapper(dbSession).updateParameter(activeRuleParam);
    }

    public void deleteParam(DbSession dbSession, ActiveRuleParamDto activeRuleParam) {
        Preconditions.checkNotNull((Object)activeRuleParam.getId(), (Object)ACTIVE_RULE_PARAM_IS_NOT_PERSISTED);
        this.deleteParamById(dbSession, activeRuleParam.getId());
    }

    public void deleteParamById(DbSession dbSession, int id) {
        ActiveRuleDao.mapper(dbSession).deleteParameter(id);
    }

    public void deleteParamsByRuleParamOfAllOrganizations(DbSession dbSession, RuleParamDto param) {
        List<ActiveRuleDto> activeRules = this.selectByRuleIdOfAllOrganizations(dbSession, param.getRuleId());
        for (ActiveRuleDto activeRule : activeRules) {
            for (ActiveRuleParamDto activeParam : this.selectParamsByActiveRuleId(dbSession, activeRule.getId())) {
                if (!activeParam.getKey().equals(param.getName())) continue;
                this.deleteParam(dbSession, activeParam);
            }
        }
    }

    public void deleteParamsByActiveRuleIds(DbSession dbSession, List<Integer> activeRuleIds) {
        ActiveRuleMapper mapper = ActiveRuleDao.mapper(dbSession);
        DatabaseUtils.executeLargeUpdates(activeRuleIds, mapper::deleteParamsByActiveRuleIds);
    }

    public Map<String, Long> countActiveRulesByQuery(DbSession dbSession, ActiveRuleCountQuery query) {
        return KeyLongValue.toMap(DatabaseUtils.executeLargeInputs(query.getProfileUuids(), partition -> ActiveRuleDao.mapper(dbSession).countActiveRulesByQuery(query.getOrganization().getUuid(), (List<String>)partition, query.getRuleStatus(), query.getInheritance())));
    }

    public void scrollAllForIndexing(DbSession dbSession, Consumer<IndexedActiveRuleDto> consumer) {
        ActiveRuleDao.mapper(dbSession).scrollAllForIndexing((ResultHandler<IndexedActiveRuleDto>)((ResultHandler)context -> {
            IndexedActiveRuleDto dto = (IndexedActiveRuleDto)context.getResultObject();
            consumer.accept(dto);
        }));
    }

    public void scrollByIdsForIndexing(DbSession dbSession, Collection<Long> ids, Consumer<IndexedActiveRuleDto> consumer) {
        ActiveRuleMapper mapper = ActiveRuleDao.mapper(dbSession);
        DatabaseUtils.executeLargeInputsWithoutOutput(ids, pageOfIds -> mapper.scrollByIdsForIndexing((Collection<Long>)pageOfIds, (ResultHandler<IndexedActiveRuleDto>)((ResultHandler)context -> {
            IndexedActiveRuleDto dto = (IndexedActiveRuleDto)context.getResultObject();
            consumer.accept(dto);
        })));
    }

    public void scrollByRuleProfileForIndexing(DbSession dbSession, String ruleProfileUuid, Consumer<IndexedActiveRuleDto> consumer) {
        ActiveRuleDao.mapper(dbSession).scrollByRuleProfileUuidForIndexing(ruleProfileUuid, (ResultHandler<IndexedActiveRuleDto>)((ResultHandler)context -> {
            IndexedActiveRuleDto dto = (IndexedActiveRuleDto)context.getResultObject();
            consumer.accept(dto);
        }));
    }

    private static ActiveRuleMapper mapper(DbSession dbSession) {
        return (ActiveRuleMapper)dbSession.getMapper(ActiveRuleMapper.class);
    }
}

