/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.qualityprofile;

import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.rule.RuleKey;
import org.sonar.db.qualityprofile.ActiveRuleKey;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.rule.SeverityUtil;

public class ActiveRuleDto {
    public static final String INHERITED = "INHERITED";
    public static final String OVERRIDES = "OVERRIDES";
    private Integer id;
    private Integer profileId;
    private Integer ruleId;
    private Integer severity;
    private String inheritance;
    private long createdAt;
    private long updatedAt;
    private String repository;
    private String ruleField;
    private String ruleProfileUuid;
    private String securityStandards;

    public ActiveRuleDto setKey(ActiveRuleKey key) {
        this.repository = key.getRuleKey().repository();
        this.ruleField = key.getRuleKey().rule();
        this.ruleProfileUuid = key.getRuleProfileUuid();
        return this;
    }

    public ActiveRuleKey getKey() {
        return new ActiveRuleKey(this.ruleProfileUuid, RuleKey.of((String)this.repository, (String)this.ruleField));
    }

    public RuleKey getRuleKey() {
        return RuleKey.of((String)this.repository, (String)this.ruleField);
    }

    public Integer getId() {
        return this.id;
    }

    public ActiveRuleDto setId(Integer id) {
        this.id = id;
        return this;
    }

    public Integer getProfileId() {
        return this.profileId;
    }

    public ActiveRuleDto setProfileId(Integer profileId) {
        this.profileId = profileId;
        return this;
    }

    public Integer getRuleId() {
        return this.ruleId;
    }

    public ActiveRuleDto setRuleId(Integer ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    public Integer getSeverity() {
        return this.severity;
    }

    public String getSeverityString() {
        return SeverityUtil.getSeverityFromOrdinal(this.severity);
    }

    public ActiveRuleDto setSeverity(Integer severity) {
        this.severity = severity;
        return this;
    }

    public ActiveRuleDto setSeverity(String severity) {
        this.severity = SeverityUtil.getOrdinalFromSeverity(severity);
        return this;
    }

    @CheckForNull
    public String getInheritance() {
        return this.inheritance;
    }

    public ActiveRuleDto setInheritance(@Nullable String inheritance) {
        this.inheritance = inheritance;
        return this;
    }

    public boolean isInherited() {
        return StringUtils.equals((String)INHERITED, (String)this.inheritance);
    }

    public boolean doesOverride() {
        return StringUtils.equals((String)OVERRIDES, (String)this.inheritance);
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public ActiveRuleDto setUpdatedAt(long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public ActiveRuleDto setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public String getSecurityStandards() {
        return this.securityStandards;
    }

    public ActiveRuleDto setSecurityStandards(String securityStandards) {
        this.securityStandards = securityStandards;
        return this;
    }

    public static ActiveRuleDto createFor(QProfileDto profile, RuleDefinitionDto ruleDto) {
        Objects.requireNonNull(profile.getId(), "Profile is not persisted");
        Objects.requireNonNull(ruleDto.getId(), "Rule is not persisted");
        ActiveRuleDto dto = new ActiveRuleDto();
        dto.setProfileId(profile.getId());
        dto.setRuleId(ruleDto.getId());
        dto.setKey(ActiveRuleKey.of(profile, ruleDto.getKey()));
        return dto;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).toString();
    }
}

