/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.qualityprofile;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.sonar.api.rule.RuleKey;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.qualityprofile.RulesProfileDto;

public class ActiveRuleKey
implements Serializable,
Comparable<ActiveRuleKey> {
    private final String ruleProfileUuid;
    private final RuleKey ruleKey;

    protected ActiveRuleKey(String ruleProfileUuid, RuleKey ruleKey) {
        this.ruleProfileUuid = ruleProfileUuid;
        this.ruleKey = ruleKey;
    }

    public static ActiveRuleKey of(QProfileDto profile, RuleKey ruleKey) {
        return new ActiveRuleKey(profile.getRulesProfileUuid(), ruleKey);
    }

    public static ActiveRuleKey of(RulesProfileDto rulesProfile, RuleKey ruleKey) {
        return new ActiveRuleKey(rulesProfile.getKee(), ruleKey);
    }

    public static ActiveRuleKey parse(String s) {
        Preconditions.checkArgument((s.split(":").length >= 3 ? 1 : 0) != 0, (Object)("Bad format of activeRule key: " + s));
        int semiColonPos = s.indexOf(58);
        String ruleProfileUuid = s.substring(0, semiColonPos);
        String ruleKey = s.substring(semiColonPos + 1);
        return new ActiveRuleKey(ruleProfileUuid, RuleKey.parse((String)ruleKey));
    }

    public RuleKey getRuleKey() {
        return this.ruleKey;
    }

    public String getRuleProfileUuid() {
        return this.ruleProfileUuid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActiveRuleKey activeRuleKey = (ActiveRuleKey)o;
        if (!this.ruleProfileUuid.equals(activeRuleKey.ruleProfileUuid)) {
            return false;
        }
        return this.ruleKey.equals((Object)activeRuleKey.ruleKey);
    }

    public int hashCode() {
        int result = this.ruleProfileUuid.hashCode();
        result = 31 * result + this.ruleKey.hashCode();
        return result;
    }

    public String toString() {
        return String.format("%s:%s", this.ruleProfileUuid, this.ruleKey.toString());
    }

    @Override
    public int compareTo(ActiveRuleKey o) {
        int compareQualityProfileKey = this.ruleProfileUuid.compareTo(o.ruleProfileUuid);
        if (compareQualityProfileKey == 0) {
            return this.ruleKey.compareTo(o.ruleKey);
        }
        return compareQualityProfileKey;
    }
}

