/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.qualityprofile;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.sonar.api.utils.System2;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.qualityprofile.DefaultQProfileDto;
import org.sonar.db.qualityprofile.DefaultQProfileMapper;

public class DefaultQProfileDao
implements Dao {
    private final System2 system2;

    public DefaultQProfileDao(System2 system2) {
        this.system2 = system2;
    }

    public void insertOrUpdate(DbSession dbSession, DefaultQProfileDto dto) {
        long now = this.system2.now();
        DefaultQProfileMapper mapper = DefaultQProfileDao.mapper(dbSession);
        if (mapper.update(dto, now) == 0) {
            mapper.insert(dto, now);
        }
    }

    public void deleteByQProfileUuids(DbSession dbSession, Collection<String> qProfileUuids) {
        DefaultQProfileMapper mapper = DefaultQProfileDao.mapper(dbSession);
        DatabaseUtils.executeLargeUpdates(qProfileUuids, mapper::deleteByQProfileUuids);
    }

    public Set<String> selectExistingQProfileUuids(DbSession dbSession, String organizationUuid, Collection<String> qProfileUuids) {
        return new HashSet<String>(DatabaseUtils.executeLargeInputs(qProfileUuids, uuids -> DefaultQProfileDao.mapper(dbSession).selectExistingQProfileUuids(organizationUuid, (Collection<String>)uuids)));
    }

    public boolean isDefault(DbSession dbSession, String organizationUuid, String qProfileUuid) {
        return this.selectExistingQProfileUuids(dbSession, organizationUuid, Collections.singletonList(qProfileUuid)).contains(qProfileUuid);
    }

    public Set<String> selectUuidsOfOrganizationsWithoutDefaultProfile(DbSession dbSession, String language) {
        return DefaultQProfileDao.mapper(dbSession).selectUuidsOfOrganizationsWithoutDefaultProfile(language);
    }

    private static DefaultQProfileMapper mapper(DbSession dbSession) {
        return (DefaultQProfileMapper)dbSession.getMapper(DefaultQProfileMapper.class);
    }
}

