/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.qualityprofile;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import org.sonar.api.utils.System2;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.qualityprofile.QProfileChangeDto;
import org.sonar.db.qualityprofile.QProfileChangeMapper;
import org.sonar.db.qualityprofile.QProfileChangeQuery;

public class QProfileChangeDao
implements Dao {
    private final System2 system2;
    private final UuidFactory uuidFactory;

    public QProfileChangeDao(System2 system2, UuidFactory uuidFactory) {
        this.system2 = system2;
        this.uuidFactory = uuidFactory;
    }

    public void insert(DbSession dbSession, QProfileChangeDto dto) {
        Preconditions.checkState((dto.getCreatedAt() == 0L ? 1 : 0) != 0, (String)"Date of QProfileChangeDto must be set by DAO only. Got %s.", (Object[])new Object[]{dto.getCreatedAt()});
        dto.setUuid(this.uuidFactory.create());
        dto.setCreatedAt(this.system2.now());
        QProfileChangeDao.mapper(dbSession).insert(dto);
    }

    public List<QProfileChangeDto> selectByQuery(DbSession dbSession, QProfileChangeQuery query) {
        return QProfileChangeDao.mapper(dbSession).selectByQuery(query);
    }

    public int countByQuery(DbSession dbSession, QProfileChangeQuery query) {
        return QProfileChangeDao.mapper(dbSession).countByQuery(query);
    }

    public void deleteByRulesProfileUuids(DbSession dbSession, Collection<String> ruleProfileUuids) {
        QProfileChangeMapper mapper = QProfileChangeDao.mapper(dbSession);
        DatabaseUtils.executeLargeUpdates(ruleProfileUuids, mapper::deleteByRuleProfileUuids);
    }

    private static QProfileChangeMapper mapper(DbSession dbSession) {
        return (QProfileChangeMapper)dbSession.getMapper(QProfileChangeMapper.class);
    }
}

