/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.source;

import com.google.common.base.Splitter;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.io.IOUtils;
import org.apache.ibatis.session.ResultHandler;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.source.FileSourceDto;
import org.sonar.db.source.FileSourceMapper;
import org.sonar.db.source.LineHashVersion;
import org.sonar.db.source.LineHashesWithUuidDto;

public class FileSourceDao
implements Dao {
    private static final Splitter END_OF_LINE_SPLITTER = Splitter.on((char)'\n');

    @CheckForNull
    public FileSourceDto selectByFileUuid(DbSession session, String fileUuid) {
        return FileSourceDao.mapper(session).selectByFileUuid(fileUuid);
    }

    @CheckForNull
    public LineHashVersion selectLineHashesVersion(DbSession dbSession, String fileUuid) {
        Integer version = FileSourceDao.mapper(dbSession).selectLineHashesVersion(fileUuid);
        return version == null ? LineHashVersion.WITHOUT_SIGNIFICANT_CODE : LineHashVersion.valueOf(version);
    }

    @CheckForNull
    public List<String> selectLineHashes(DbSession dbSession, String fileUuid) {
        List<String> string2;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection connection;
        block6: {
            String string2;
            block7: {
                connection = dbSession.getConnection();
                pstmt = null;
                rs = null;
                pstmt = connection.prepareStatement("SELECT line_hashes FROM file_sources WHERE file_uuid=?");
                pstmt.setString(1, fileUuid);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block6;
                string2 = rs.getString(1);
                if (string2 != null) break block7;
                List<String> list = Collections.emptyList();
                DbUtils.closeQuietly((Connection)connection, (Statement)pstmt, (ResultSet)rs);
                return list;
            }
            List list = END_OF_LINE_SPLITTER.splitToList((CharSequence)string2);
            DbUtils.closeQuietly((Connection)connection, (Statement)pstmt, (ResultSet)rs);
            return list;
        }
        try {
            string2 = null;
        }
        catch (SQLException e) {
            try {
                throw new IllegalStateException("Fail to read FILE_SOURCES.LINE_HASHES of file " + fileUuid, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly((Connection)connection, (Statement)pstmt, rs);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Connection)connection, (Statement)pstmt, (ResultSet)rs);
        return string2;
    }

    public void scrollLineHashes(DbSession dbSession, Collection<String> fileUUids, ResultHandler<LineHashesWithUuidDto> rowHandler) {
        for (List partition : DatabaseUtils.toUniqueAndSortedPartitions(fileUUids)) {
            FileSourceDao.mapper(dbSession).scrollLineHashes(partition, rowHandler);
        }
    }

    public void readLineHashesStream(DbSession dbSession, String fileUuid, Consumer<Reader> consumer) {
        Connection connection = dbSession.getConnection();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Reader reader = null;
        try {
            pstmt = connection.prepareStatement("SELECT line_hashes FROM file_sources WHERE file_uuid=?");
            pstmt.setString(1, fileUuid);
            rs = pstmt.executeQuery();
            if (rs.next() && (reader = rs.getCharacterStream(1)) != null) {
                consumer.accept(reader);
            }
        }
        catch (SQLException e) {
            try {
                throw new IllegalStateException("Fail to read FILE_SOURCES.LINE_HASHES of file " + fileUuid, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                DbUtils.closeQuietly((Connection)connection, (Statement)pstmt, rs);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(reader);
        DbUtils.closeQuietly((Connection)connection, (Statement)pstmt, (ResultSet)rs);
    }

    public void insert(DbSession session, FileSourceDto dto) {
        FileSourceDao.mapper(session).insert(dto);
    }

    public void update(DbSession session, FileSourceDto dto) {
        FileSourceDao.mapper(session).update(dto);
    }

    private static FileSourceMapper mapper(DbSession session) {
        return (FileSourceMapper)session.getMapper(FileSourceMapper.class);
    }
}

